/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;
import sklearn.TypeUtil;

public class LookupTransformer
extends Transformer {
    public LookupTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public DataType getDataType() {
        Map<?, ?> mapping = this.getMapping();
        ArrayList inputValues = new ArrayList(mapping.keySet());
        return TypeUtil.getDataType(inputValues, DataType.STRING);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Map<?, ?> mapping = this.getMapping();
        Object defaultValue = this.getDefaultValue();
        List<String> columns = this.formatColumns(features);
        ClassDictUtil.checkSize(features.size() + 1, columns);
        MapValues mapValues = new MapValues();
        List<String> inputColumns = columns.subList(0, columns.size() - 1);
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            String inputColumn = inputColumns.get(i);
            mapValues.addFieldColumnPairs(new FieldColumnPair[]{new FieldColumnPair(feature.getName(), inputColumn)});
        }
        String outputColumn = columns.get(columns.size() - 1);
        mapValues.setOutputColumn(outputColumn);
        Map<String, List<Object>> data = this.parseMapping(inputColumns, outputColumn, mapping);
        mapValues.setInlineTable(PMMLUtil.createInlineTable(data));
        ArrayList<Object> outputValues = new ArrayList<Object>();
        outputValues.addAll((Collection)data.get(outputColumn));
        if (defaultValue != null) {
            mapValues.setDefaultValue(ValueUtil.formatValue((Object)defaultValue));
            outputValues.add(defaultValue);
        }
        FieldName name = FeatureUtil.createName((String)"lookup", features);
        DerivedField derivedField = encoder.createDerivedField(name, OpType.CATEGORICAL, TypeUtil.getDataType(outputValues, DataType.STRING), (Expression)mapValues);
        Feature feature = new Feature((PMMLEncoder)encoder, derivedField.getName(), derivedField.getDataType()){

            public ContinuousFeature toContinuousFeature() {
                PMMLEncoder encoder = this.getEncoder();
                DerivedField derivedField = (DerivedField)encoder.toContinuous(this.getName());
                return new ContinuousFeature(encoder, (Field)derivedField);
            }
        };
        return Collections.singletonList(feature);
    }

    protected List<String> formatColumns(List<Feature> features) {
        ClassDictUtil.checkSize(1, features);
        return Arrays.asList("data:input", "data:output");
    }

    protected Map<String, List<Object>> parseMapping(List<String> inputColumns, String outputColumn, Map<?, ?> mapping) {
        ArrayList inputValues = new ArrayList();
        ArrayList outputValues = new ArrayList();
        Set<Map.Entry<?, ?>> entries = mapping.entrySet();
        for (Map.Entry entry : entries) {
            Object inputValue = entry.getKey();
            Object outputValue = entry.getValue();
            if (inputValue == null) {
                throw new IllegalArgumentException();
            }
            if (outputValue == null) continue;
            inputValues.add(inputValue);
            outputValues.add(outputValue);
        }
        String inputColumn = inputColumns.get(0);
        LinkedHashMap<String, List<Object>> linkedHashMap = new LinkedHashMap<String, List<Object>>();
        linkedHashMap.put(inputColumn, inputValues);
        linkedHashMap.put(outputColumn, outputValues);
        return linkedHashMap;
    }

    public Map<?, ?> getMapping() {
        return this.get("mapping", Map.class);
    }

    public Object getDefaultValue() {
        return this.get("default_value");
    }
}

