/*
 * Decompiled with CFR 0.152.
 */
package h2o.estimators;

import hex.genmodel.MojoModel;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.jpmml.converter.Schema;
import org.jpmml.h2o.Converter;
import org.jpmml.h2o.ConverterFactory;
import org.jpmml.h2o.MojoModelUtil;
import sklearn.Estimator;
import sklearn.HasClasses;

public class BaseEstimator
extends Estimator
implements HasClasses {
    private MojoModel mojoModel = null;

    public BaseEstimator(String module, String name) {
        super(module, name);
    }

    @Override
    public MiningFunction getMiningFunction() {
        String estimatorType;
        switch (estimatorType = this.getEstimatorType()) {
            case "classifier": {
                return MiningFunction.CLASSIFICATION;
            }
            case "regressor": {
                return MiningFunction.REGRESSION;
            }
        }
        throw new IllegalArgumentException(estimatorType);
    }

    @Override
    public boolean isSupervised() {
        String estimatorType;
        switch (estimatorType = this.getEstimatorType()) {
            case "classifier": 
            case "regressor": {
                return true;
            }
        }
        throw new IllegalArgumentException(estimatorType);
    }

    @Override
    public List<?> getClasses() {
        int responseIdx;
        MojoModel mojoModel = this.getMojoModel();
        String[] responseValues = mojoModel.getDomainValues(responseIdx = mojoModel.getResponseIdx());
        if (responseValues == null) {
            throw new IllegalArgumentException();
        }
        return Arrays.asList(responseValues);
    }

    public boolean hasProbabilityDistribution() {
        String estimatorType;
        switch (estimatorType = this.getEstimatorType()) {
            case "classifier": {
                return true;
            }
            case "regressor": {
                return false;
            }
        }
        throw new IllegalArgumentException(estimatorType);
    }

    @Override
    public Model encodeModel(Schema schema) {
        Converter converter;
        MojoModel mojoModel = this.getMojoModel();
        try {
            ConverterFactory converterFactory = ConverterFactory.newConverterFactory();
            converter = converterFactory.newConverter(mojoModel);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return converter.encodeModel(schema);
    }

    public String getEstimatorType() {
        return (String)this.get("_estimator_type");
    }

    public String getMojoPath() {
        return this.get("_mojo_path", String.class);
    }

    public BaseEstimator setMojoPath(String mojoPath) {
        this.put("_mojo_path", mojoPath);
        return this;
    }

    private MojoModel getMojoModel() {
        if (this.mojoModel == null) {
            this.mojoModel = this.loadMojoModel();
        }
        return this.mojoModel;
    }

    private MojoModel loadMojoModel() {
        MojoModel mojoModel;
        String mojoPath = this.getMojoPath();
        try {
            mojoModel = MojoModelUtil.readFrom((File)new File(mojoPath), (boolean)false);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return mojoModel;
    }
}

