/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sklearn;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.CompoundPredicate;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.jpmml.converter.Feature;
import org.jpmml.sklearn.AbstractTranslator;
import org.jpmml.sklearn.ParseException;
import org.jpmml.sklearn.PredicateTranslatorConstants;
import org.jpmml.sklearn.PredicateTranslatorTokenManager;
import org.jpmml.sklearn.Provider;
import org.jpmml.sklearn.SimpleCharStream;
import org.jpmml.sklearn.StringProvider;
import org.jpmml.sklearn.Token;
import org.jpmml.sklearn.TokenMgrException;

public class PredicateTranslator
extends AbstractTranslator
implements PredicateTranslatorConstants {
    public PredicateTranslatorTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[7];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static Predicate translate(String string, List<? extends Feature> features) {
        Predicate predicate;
        try {
            PredicateTranslator predicateTranslator = new PredicateTranslator(string);
            predicateTranslator.setFeatures(features);
            predicate = predicateTranslator.translatePredicateInternal();
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException(pe);
        }
        return predicate;
    }

    private static SimplePredicate.Operator translateRelationalOperator(Token operator) {
        switch (operator.kind) {
            case 7: {
                return SimplePredicate.Operator.EQUAL;
            }
            case 8: {
                return SimplePredicate.Operator.NOT_EQUAL;
            }
            case 9: {
                return SimplePredicate.Operator.LESS_THAN;
            }
            case 10: {
                return SimplePredicate.Operator.LESS_OR_EQUAL;
            }
            case 11: {
                return SimplePredicate.Operator.GREATER_THAN;
            }
            case 12: {
                return SimplePredicate.Operator.GREATER_OR_EQUAL;
            }
        }
        throw new IllegalArgumentException(operator.image);
    }

    private static String translateValue(Token value) {
        String image = value.image;
        switch (value.kind) {
            case 15: {
                if (!image.endsWith("l") && !image.endsWith("L")) break;
                image = image.substring(0, image.length() - 1);
                break;
            }
        }
        return image;
    }

    private static CompoundPredicate createCompoundPredicate(CompoundPredicate.BooleanOperator booleanOperator, Predicate ... predicates) {
        CompoundPredicate compoundPredicate = new CompoundPredicate(booleanOperator).addPredicates(predicates);
        return compoundPredicate;
    }

    private static SimplePredicate createSimplePredicate(FieldName field, SimplePredicate.Operator operator) {
        SimplePredicate simplePredicate = new SimplePredicate(field, operator);
        return simplePredicate;
    }

    private static SimplePredicate createSimplePredicate(FieldName field, SimplePredicate.Operator operator, String value) {
        SimplePredicate simplePredicate = new SimplePredicate(field, operator).setValue(value);
        return simplePredicate;
    }

    private final Predicate translatePredicateInternal() throws ParseException {
        Predicate predicate = this.Predicate();
        this.jj_consume_token(0);
        return predicate;
    }

    public final Predicate Predicate() throws ParseException {
        Predicate predicate = this.LogicalOrExpression();
        return predicate;
    }

    public final Predicate LogicalOrExpression() throws ParseException {
        Predicate left = this.LogicalAndExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(5);
            Predicate right = this.LogicalAndExpression();
            left = PredicateTranslator.createCompoundPredicate(CompoundPredicate.BooleanOperator.OR, left, right);
        }
        return left;
    }

    public final Predicate LogicalAndExpression() throws ParseException {
        Predicate left = this.ComparisonExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 6: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(6);
            Predicate right = this.ComparisonExpression();
            left = PredicateTranslator.createCompoundPredicate(CompoundPredicate.BooleanOperator.AND, left, right);
        }
        return left;
    }

    public final Predicate ComparisonExpression() throws ParseException {
        Object left = this.PrimaryExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                Token operator;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 7: {
                        operator = this.jj_consume_token(7);
                        break;
                    }
                    case 8: {
                        operator = this.jj_consume_token(8);
                        break;
                    }
                    case 9: {
                        operator = this.jj_consume_token(9);
                        break;
                    }
                    case 10: {
                        operator = this.jj_consume_token(10);
                        break;
                    }
                    case 11: {
                        operator = this.jj_consume_token(11);
                        break;
                    }
                    case 12: {
                        operator = this.jj_consume_token(12);
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                Object right = this.PrimaryExpression();
                left = PredicateTranslator.createSimplePredicate((FieldName)left, PredicateTranslator.translateRelationalOperator(operator), (String)right);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        return (Predicate)left;
    }

    public final Object PrimaryExpression() throws ParseException {
        Object result;
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            result = this.ArrayIndexingExpression();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: {
                    result = this.ParenthesizedExpression();
                    break;
                }
                case 15: 
                case 16: {
                    result = this.LiteralExpression();
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return result;
    }

    public final FieldName ArrayIndexingExpression() throws ParseException {
        Feature feature;
        Token column;
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            Token variable = this.jj_consume_token(17);
            this.jj_consume_token(13);
            column = this.jj_consume_token(15);
            this.jj_consume_token(14);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 17: {
                    Token variable = this.jj_consume_token(17);
                    this.jj_consume_token(13);
                    column = this.jj_consume_token(18);
                    this.jj_consume_token(14);
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        switch (column.kind) {
            case 15: {
                int index = Integer.parseInt(column.image);
                feature = this.getFeature(index);
                break;
            }
            case 18: {
                FieldName name = FieldName.create((String)column.image.substring(1, column.image.length() - 1));
                feature = this.getFeature(name);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return feature.getName();
    }

    public final Predicate ParenthesizedExpression() throws ParseException {
        this.jj_consume_token(3);
        Predicate predicate = this.Predicate();
        this.jj_consume_token(4);
        return predicate;
    }

    public final String LiteralExpression() throws ParseException {
        Token value;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 15: {
                value = this.jj_consume_token(15);
                break;
            }
            case 16: {
                value = this.jj_consume_token(16);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return PredicateTranslator.translateValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        return this.jj_scan_token(13);
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_scan_token(13)) {
            return true;
        }
        return this.jj_scan_token(15);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{32, 64, 8064, 8064, 98312, 131072, 98304};
    }

    public PredicateTranslator(Provider stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new PredicateTranslatorTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public PredicateTranslator(String dsl) throws ParseException, TokenMgrException {
        this(new StringProvider(dsl));
    }

    public void ReInit(String s) {
        this.ReInit(new StringProvider(s));
    }

    public void ReInit(Provider stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new PredicateTranslatorTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public PredicateTranslator(PredicateTranslatorTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(PredicateTranslatorTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 7; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[23];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 7; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 23; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage, this.token_source == null ? null : PredicateTranslatorTokenManager.lexStateNames[this.token_source.curLexState]);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        PredicateTranslator.jj_la1_init_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends RuntimeException {
        private LookaheadSuccess() {
        }
    }
}

