/*
 * Decompiled with CFR 0.152.
 */
package sklearn.linear_model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.regression.RegressionModel;
import org.jpmml.converter.CMatrixUtil;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.Transformation;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.converter.regression.RegressionModelUtil;
import sklearn.Classifier;
import sklearn.ClassifierUtil;

public class LinearClassifier
extends Classifier {
    public LinearClassifier(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getCoefShape();
        return shape[1];
    }

    @Override
    public Model encodeModel(Schema schema) {
        int[] shape = this.getCoefShape();
        int numberOfClasses = shape[0];
        int numberOfFeatures = shape[1];
        boolean hasProbabilityDistribution = this.hasProbabilityDistribution();
        List<? extends Number> coef = this.getCoef();
        List<? extends Number> intercepts = this.getIntercept();
        CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
        List features = schema.getFeatures();
        if (numberOfClasses == 1) {
            ClassifierUtil.checkSize(2, categoricalLabel);
            return RegressionModelUtil.createBinaryLogisticClassification((List)features, (List)ValueUtil.asDoubles((List)CMatrixUtil.getRow(coef, (int)numberOfClasses, (int)numberOfFeatures, (int)0)), (Double)ValueUtil.asDouble((Number)intercepts.get(0)), (RegressionModel.NormalizationMethod)RegressionModel.NormalizationMethod.LOGIT, (boolean)hasProbabilityDistribution, (Schema)schema);
        }
        if (numberOfClasses >= 3) {
            ClassifierUtil.checkSize(numberOfClasses, categoricalLabel);
            Schema segmentSchema = new Schema((Label)new ContinuousLabel(null, DataType.DOUBLE), Collections.emptyList());
            ArrayList<RegressionModel> regressionModels = new ArrayList<RegressionModel>();
            int rows = categoricalLabel.size();
            for (int i = 0; i < rows; ++i) {
                RegressionModel regressionModel = RegressionModelUtil.createRegression((List)features, (List)ValueUtil.asDoubles((List)CMatrixUtil.getRow(coef, (int)numberOfClasses, (int)numberOfFeatures, (int)i)), (Double)ValueUtil.asDouble((Number)intercepts.get(i)), (RegressionModel.NormalizationMethod)RegressionModel.NormalizationMethod.LOGIT, (Schema)segmentSchema).setOutput(ModelUtil.createPredictedOutput((FieldName)FieldName.create((String)("decisionFunction(" + categoricalLabel.getValue(i) + ")")), (OpType)OpType.CONTINUOUS, (DataType)DataType.DOUBLE, (Transformation[])new Transformation[0]));
                regressionModels.add(regressionModel);
            }
            return MiningModelUtil.createClassification(regressionModels, (RegressionModel.NormalizationMethod)RegressionModel.NormalizationMethod.SIMPLEMAX, (boolean)hasProbabilityDistribution, (Schema)schema);
        }
        throw new IllegalArgumentException();
    }

    public List<? extends Number> getCoef() {
        return this.getArray("coef_", Number.class);
    }

    public int[] getCoefShape() {
        return this.getArrayShape("coef_", 2);
    }

    public List<? extends Number> getIntercept() {
        return this.getArray("intercept_", Number.class);
    }
}

