/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MissingValueTreatmentMethod;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.MissingValueDecorator;
import org.jpmml.converter.ObjectFeature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.StringFeature;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.SkLearnEncoder;

public class ImputerUtil {
    private ImputerUtil() {
    }

    public static Feature encodeFeature(Feature feature, Object missingValue, Object replacementValue, MissingValueTreatmentMethod missingValueTreatmentMethod, SkLearnEncoder encoder) {
        Field field = encoder.getField(feature.getName());
        if (field instanceof DataField) {
            MissingValueDecorator missingValueDecorator = new MissingValueDecorator().setMissingValueReplacement(ValueUtil.formatValue((Object)replacementValue)).setMissingValueTreatment(missingValueTreatmentMethod);
            if (missingValue != null) {
                missingValueDecorator.addValues(new String[]{ValueUtil.formatValue((Object)missingValue)});
            }
            encoder.addDecorator(feature.getName(), (Decorator)missingValueDecorator);
            return feature;
        }
        if (field instanceof DerivedField) {
            FieldRef expression = feature.ref();
            expression = missingValue != null ? PMMLUtil.createApply((String)"equal", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Object)missingValue, (DataType)feature.getDataType())}) : PMMLUtil.createApply((String)"isMissing", (Expression[])new Expression[]{expression});
            expression = PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Object)replacementValue, (DataType)feature.getDataType()), feature.ref()});
            DerivedField derivedField = encoder.createDerivedField(FeatureUtil.createName((String)"imputer", (Feature)feature), (Expression)expression);
            DataType dataType = derivedField.getDataType();
            switch (dataType) {
                case INTEGER: 
                case FLOAT: 
                case DOUBLE: {
                    return new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField);
                }
                case STRING: {
                    return new StringFeature((PMMLEncoder)encoder, (Field)derivedField);
                }
            }
            return new ObjectFeature((PMMLEncoder)encoder, derivedField.getName(), derivedField.getDataType());
        }
        throw new IllegalArgumentException();
    }
}

