/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.OpType;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;
import sklearn.TypeUtil;

public class LabelEncoder
extends Transformer {
    public LabelEncoder(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public DataType getDataType() {
        List<?> classes = this.getClasses();
        return TypeUtil.getDataType(classes, DataType.STRING);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<?> classes = this.getClasses();
        ClassDictUtil.checkSize(1, features);
        Feature feature = features.get(0);
        ArrayList<String> inputCategories = new ArrayList<String>();
        ArrayList<String> outputCategories = new ArrayList<String>();
        for (int i = 0; i < classes.size(); ++i) {
            inputCategories.add(ValueUtil.formatValue(classes.get(i)));
            outputCategories.add(ValueUtil.formatValue((Number)i));
        }
        FieldName name = FeatureUtil.createName((String)"label_encoder", (Feature)feature);
        DerivedField derivedField = encoder.getDerivedField(name);
        if (derivedField == null) {
            encoder.toCategorical(feature.getName(), inputCategories);
            MapValues mapValues = PMMLUtil.createMapValues((FieldName)feature.getName(), inputCategories, outputCategories);
            derivedField = encoder.createDerivedField(name, OpType.CATEGORICAL, DataType.INTEGER, (Expression)mapValues);
        }
        CategoricalFeature encodedFeature = new CategoricalFeature((PMMLEncoder)encoder, (Field)derivedField, outputCategories);
        CategoricalFeature result = new CategoricalFeature((PMMLEncoder)encoder, feature, inputCategories, (Feature)encodedFeature){
            final /* synthetic */ Feature val$encodedFeature;
            {
                this.val$encodedFeature = feature;
                super(x0, x1, x2);
            }

            public ContinuousFeature toContinuousFeature() {
                return this.val$encodedFeature.toContinuousFeature();
            }
        };
        return Collections.singletonList(result);
    }

    public List<?> getClasses() {
        return this.getArray("classes_");
    }
}

