/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.decoration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Interval;
import org.dmg.pmml.NumericInfo;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutlierTreatmentMethod;
import org.dmg.pmml.UnivariateStats;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.Feature;
import org.jpmml.converter.OutlierDecorator;
import org.jpmml.converter.ValidValueDecorator;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn2pmml.decoration.Domain;
import sklearn2pmml.decoration.DomainUtil;

public class ContinuousDomain
extends Domain {
    public ContinuousDomain(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        return OpType.CONTINUOUS;
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Double highValue;
        Double lowValue;
        OutlierTreatmentMethod outlierTreatment = DomainUtil.parseOutlierTreatment(this.getOutlierTreatment());
        if (outlierTreatment != null) {
            switch (outlierTreatment) {
                case AS_EXTREME_VALUES: 
                case AS_MISSING_VALUES: {
                    lowValue = this.getLowValue().doubleValue();
                    highValue = this.getHighValue().doubleValue();
                    break;
                }
                default: {
                    lowValue = null;
                    highValue = null;
                    break;
                }
            }
        } else {
            lowValue = null;
            highValue = null;
        }
        Boolean withData = this.getWithData();
        Boolean withStatistics = this.getWithStatistics();
        List<? extends Number> dataMin = null;
        List<? extends Number> dataMax = null;
        if (withData.booleanValue()) {
            dataMin = this.getDataMin();
            dataMax = this.getDataMax();
            ClassDictUtil.checkSize(features, dataMin, dataMax);
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            WildcardFeature wildcardFeature = (WildcardFeature)feature;
            if (outlierTreatment != null) {
                OutlierDecorator outlierDecorator = new OutlierDecorator().setOutlierTreatment(outlierTreatment).setLowValue(lowValue).setHighValue(highValue);
                encoder.addDecorator(wildcardFeature.getName(), (Decorator)outlierDecorator);
            }
            if (withData.booleanValue()) {
                Interval interval = new Interval(Interval.Closure.CLOSED_CLOSED).setLeftMargin(ValueUtil.asDouble((Number)dataMin.get(i))).setRightMargin(ValueUtil.asDouble((Number)dataMax.get(i)));
                ValidValueDecorator validValueDecorator = new ValidValueDecorator().addIntervals(new Interval[]{interval});
                feature = wildcardFeature.toContinuousFeature();
                encoder.addDecorator(wildcardFeature.getName(), (Decorator)validValueDecorator);
            }
            if (withStatistics.booleanValue()) {
                Map<String, ?> counts = ContinuousDomain.extractMap(this.getCounts(), i);
                Map<String, ?> numericInfo = ContinuousDomain.extractMap(this.getNumericInfo(), i);
                UnivariateStats univariateStats = new UnivariateStats().setField(wildcardFeature.getName()).setCounts(ContinuousDomain.createCounts(counts)).setNumericInfo(ContinuousDomain.createNumericInfo(numericInfo));
                encoder.putUnivariateStats(univariateStats);
            }
            result.add(feature);
        }
        return super.encodeFeatures(result, encoder);
    }

    public String getOutlierTreatment() {
        return (String)this.get("outlier_treatment");
    }

    public Number getLowValue() {
        return this.get("low_value", Number.class);
    }

    public Number getHighValue() {
        return this.get("high_value", Number.class);
    }

    public List<? extends Number> getDataMin() {
        return this.getArray("data_min_", Number.class);
    }

    public List<? extends Number> getDataMax() {
        return this.getArray("data_max_", Number.class);
    }

    public Map<String, ?> getNumericInfo() {
        return this.get("numeric_info_", Map.class);
    }

    public static NumericInfo createNumericInfo(Map<String, ?> values) {
        NumericInfo numericInfo = new NumericInfo().setMinimum(ContinuousDomain.selectValue(values, "minimum")).setMaximum(ContinuousDomain.selectValue(values, "maximum")).setMean(ContinuousDomain.selectValue(values, "mean")).setStandardDeviation(ContinuousDomain.selectValue(values, "standardDeviation")).setMedian(ContinuousDomain.selectValue(values, "median")).setInterQuartileRange(ContinuousDomain.selectValue(values, "interQuartileRange"));
        return numericInfo;
    }
}

