/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sklearn;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Visitable;
import org.jpmml.converter.Feature;
import org.jpmml.converter.visitors.ExpressionCompactor;
import org.jpmml.sklearn.AbstractTranslator;
import org.jpmml.sklearn.ExpressionTranslatorConstants;
import org.jpmml.sklearn.ExpressionTranslatorTokenManager;
import org.jpmml.sklearn.ParseException;
import org.jpmml.sklearn.Provider;
import org.jpmml.sklearn.SimpleCharStream;
import org.jpmml.sklearn.StringProvider;
import org.jpmml.sklearn.Token;
import org.jpmml.sklearn.TokenMgrException;

public class ExpressionTranslator
extends AbstractTranslator
implements ExpressionTranslatorConstants {
    public ExpressionTranslatorTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[16];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static Expression translate(String string, List<? extends Feature> features) {
        return ExpressionTranslator.translate(string, features, true);
    }

    public static Expression translate(String string, List<? extends Feature> features, boolean compact) {
        Expression expression;
        try {
            ExpressionTranslator expressionTranslator = new ExpressionTranslator(string);
            expressionTranslator.setFeatures(features);
            expression = expressionTranslator.translateExpressionInternal();
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("Python expression '" + string + "' is either invalid or not supported", pe);
        }
        if (compact) {
            ExpressionCompactor compactor = new ExpressionCompactor();
            compactor.applyTo((Visitable)expression);
        }
        return expression;
    }

    private static String translateRelationalOperator(Token operator) {
        switch (operator.kind) {
            case 10: {
                return "equal";
            }
            case 11: {
                return "notEqual";
            }
            case 12: {
                return "lessThan";
            }
            case 13: {
                return "lessOrEqual";
            }
            case 14: {
                return "greaterThan";
            }
            case 15: {
                return "greaterOrEqual";
            }
        }
        throw new IllegalArgumentException(operator.image);
    }

    private static Apply translateFunction(String function, List<Expression> arguments) {
        switch (function) {
            case "pandas.isnull": {
                if (arguments.size() != 1) {
                    throw new IllegalArgumentException();
                }
                return ExpressionTranslator.createApply("isMissing", arguments.get(0));
            }
            case "pandas.notnull": {
                if (arguments.size() != 1) {
                    throw new IllegalArgumentException();
                }
                return ExpressionTranslator.createApply("isNotMissing", arguments.get(0));
            }
        }
        throw new IllegalArgumentException(function);
    }

    private static String translateValue(Token value) {
        String image = value.image;
        switch (value.kind) {
            case 24: 
            case 25: {
                image = image.toLowerCase();
                break;
            }
            case 26: {
                if (!image.endsWith("l") && !image.endsWith("L")) break;
                image = image.substring(0, image.length() - 1);
                break;
            }
            case 29: {
                image = image.substring(1, image.length() - 1);
                break;
            }
        }
        return image;
    }

    private static Apply createApply(String function, Expression ... expressions) {
        Apply apply = new Apply(function);
        for (Expression expression : expressions) {
            apply.addExpressions(new Expression[]{expression});
        }
        return apply;
    }

    private final Expression translateExpressionInternal() throws ParseException {
        Expression expression = this.Expression();
        this.jj_consume_token(0);
        return expression;
    }

    public final Expression Expression() throws ParseException {
        Expression expression = this.IfElseExpression();
        return expression;
    }

    public final Expression IfElseExpression() throws ParseException {
        Expression left = this.LogicalOrExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 5: {
                this.jj_consume_token(5);
                Expression center = this.LogicalOrExpression();
                this.jj_consume_token(6);
                Expression right = this.LogicalOrExpression();
                left = ExpressionTranslator.createApply("if", center, left, right);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        return left;
    }

    public final Expression LogicalOrExpression() throws ParseException {
        Expression left = this.LogicalAndExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 7: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(7);
            Expression right = this.LogicalAndExpression();
            left = ExpressionTranslator.createApply("or", left, right);
        }
        return left;
    }

    public final Expression LogicalAndExpression() throws ParseException {
        Expression left = this.NegationExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(8);
            Expression right = this.NegationExpression();
            left = ExpressionTranslator.createApply("and", left, right);
        }
        return left;
    }

    public final Expression NegationExpression() throws ParseException {
        Token operator = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: {
                operator = this.jj_consume_token(9);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        Expression expression = this.ComparisonExpression();
        if (operator != null) {
            return ExpressionTranslator.createApply("not", expression);
        }
        return expression;
    }

    public final Expression ComparisonExpression() throws ParseException {
        Expression left = this.AdditiveExpression();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                Token operator;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 10: {
                        operator = this.jj_consume_token(10);
                        break;
                    }
                    case 11: {
                        operator = this.jj_consume_token(11);
                        break;
                    }
                    case 12: {
                        operator = this.jj_consume_token(12);
                        break;
                    }
                    case 13: {
                        operator = this.jj_consume_token(13);
                        break;
                    }
                    case 14: {
                        operator = this.jj_consume_token(14);
                        break;
                    }
                    case 15: {
                        operator = this.jj_consume_token(15);
                        break;
                    }
                    default: {
                        this.jj_la1[4] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                Expression right = this.AdditiveExpression();
                left = ExpressionTranslator.createApply(ExpressionTranslator.translateRelationalOperator(operator), left, right);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        return left;
    }

    public final Expression AdditiveExpression() throws ParseException {
        Expression left = this.MultiplicativeExpression();
        block7: while (true) {
            Token operator;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 18: 
                case 19: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 18: {
                    operator = this.jj_consume_token(18);
                    break;
                }
                case 19: {
                    operator = this.jj_consume_token(19);
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression right = this.MultiplicativeExpression();
            left = ExpressionTranslator.createApply(operator.image, left, right);
        }
        return left;
    }

    public final Expression MultiplicativeExpression() throws ParseException {
        Expression left = this.UnaryExpression();
        block7: while (true) {
            Token operator;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 16: 
                case 17: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 16: {
                    operator = this.jj_consume_token(16);
                    break;
                }
                case 17: {
                    operator = this.jj_consume_token(17);
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Expression right = this.UnaryExpression();
            left = ExpressionTranslator.createApply(operator.image, left, right);
        }
        return left;
    }

    public final Expression UnaryExpression() throws ParseException {
        Expression expression;
        Token sign = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 18: {
                sign = this.jj_consume_token(18);
                expression = this.UnaryExpression();
                break;
            }
            case 19: {
                sign = this.jj_consume_token(19);
                expression = this.UnaryExpression();
                break;
            }
            case 3: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                expression = this.PrimaryExpression();
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (sign != null && sign.kind == 19) {
            if (expression instanceof Constant) {
                Constant constant = (Constant)expression;
                String value = constant.getValue();
                value = value.startsWith("-") ? value.substring(1) : "-" + value;
                constant.setValue(value);
            } else {
                Constant constant = new Constant().setValue("-1");
                expression = ExpressionTranslator.createApply("*", new Expression[]{constant, expression});
            }
        }
        return expression;
    }

    public final Expression PrimaryExpression() throws ParseException {
        FieldRef expression;
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            expression = this.ArrayIndexingExpression();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 28: {
                    expression = this.FunctionInvocationExpression();
                    break;
                }
                case 3: {
                    expression = this.ParenthesizedExpression();
                    break;
                }
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 29: {
                    expression = this.LiteralExpression();
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return expression;
    }

    public final FieldRef ArrayIndexingExpression() throws ParseException {
        Feature feature;
        Token column;
        Token variable;
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            variable = this.jj_consume_token(28);
            this.jj_consume_token(20);
            column = this.jj_consume_token(26);
            this.jj_consume_token(21);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 28: {
                    variable = this.jj_consume_token(28);
                    this.jj_consume_token(20);
                    column = this.jj_consume_token(29);
                    this.jj_consume_token(21);
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        if (!"X".equals(variable.image)) {
            throw new IllegalArgumentException(variable.image);
        }
        switch (column.kind) {
            case 26: {
                int index = Integer.parseInt(column.image);
                feature = this.getFeature(index);
                break;
            }
            case 29: {
                FieldName name = FieldName.create((String)column.image.substring(1, column.image.length() - 1));
                feature = this.getFeature(name);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return feature.ref();
    }

    public final Expression FunctionInvocationExpression() throws ParseException {
        StringBuilder function = new StringBuilder();
        Token name = this.jj_consume_token(28);
        function.append(name.image);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 23: {
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(23);
            name = this.jj_consume_token(28);
            function.append('.').append(name.image);
        }
        this.jj_consume_token(3);
        List<Expression> arguments = this.ArgumentList();
        this.jj_consume_token(4);
        return ExpressionTranslator.translateFunction(function.toString(), arguments);
    }

    public final List<Expression> ArgumentList() throws ParseException {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        Expression expression = this.Expression();
        expressions.add(expression);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(22);
            expression = this.Expression();
            expressions.add(expression);
        }
        return expressions;
    }

    public final Expression ParenthesizedExpression() throws ParseException {
        this.jj_consume_token(3);
        Expression expression = this.Expression();
        this.jj_consume_token(4);
        return expression;
    }

    public final Constant LiteralExpression() throws ParseException {
        DataType dataType;
        Token value;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 24: {
                value = this.jj_consume_token(24);
                dataType = DataType.BOOLEAN;
                break;
            }
            case 25: {
                value = this.jj_consume_token(25);
                dataType = DataType.BOOLEAN;
                break;
            }
            case 26: {
                value = this.jj_consume_token(26);
                dataType = DataType.INTEGER;
                break;
            }
            case 27: {
                value = this.jj_consume_token(27);
                dataType = DataType.DOUBLE;
                break;
            }
            case 29: {
                value = this.jj_consume_token(29);
                dataType = DataType.STRING;
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Constant constant = new Constant().setValue(ExpressionTranslator.translateValue(value)).setDataType(dataType);
        return constant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        if (this.jj_scan_token(20)) {
            return true;
        }
        return this.jj_scan_token(26);
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        return this.jj_scan_token(20);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{32, 128, 256, 512, 64512, 64512, 786432, 786432, 196608, 196608, 1057751048, 1056964616, 0x10000000, 0x800000, 0x400000, 0x2F000000};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public ExpressionTranslator(Provider stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ExpressionTranslatorTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 16; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ExpressionTranslator(String dsl) throws ParseException, TokenMgrException {
        this(new StringProvider(dsl));
    }

    public void ReInit(String s) {
        this.ReInit(new StringProvider(s));
    }

    public void ReInit(Provider stream) {
        int i;
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new ExpressionTranslatorTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 16; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ExpressionTranslator(ExpressionTranslatorTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 16; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ExpressionTranslatorTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 16; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[34];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 16; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 34; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage, this.token_source == null ? null : ExpressionTranslatorTokenManager.lexStateNames[this.token_source.curLexState]);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        ExpressionTranslator.jj_la1_init_0();
        ExpressionTranslator.jj_la1_init_1();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends RuntimeException {
        private LookaheadSuccess() {
        }
    }
}

