/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sklearn.visitors;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.True;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.visitors.AbstractTreeModelTransformer;

public class TreeModelFlattener
extends AbstractTreeModelTransformer {
    private MiningFunction miningFunction = null;

    public void enterNode(Node node) {
        if (node.hasNodes()) {
            List children = node.getNodes();
            block0: while (true) {
                ListIterator<Node> childIt = children.listIterator();
                while (childIt.hasNext()) {
                    Node child = (Node)childIt.next();
                    Iterator<Node> grandChildIt = TreeModelFlattener.getChildren(child);
                    if (grandChildIt == null) continue;
                    childIt.remove();
                    while (grandChildIt.hasNext()) {
                        Node grandChild = grandChildIt.next();
                        grandChildIt.remove();
                        childIt.add(grandChild);
                    }
                    childIt.add(child);
                    continue block0;
                }
                break;
            }
        }
    }

    public void exitNode(Node node) {
        Predicate predicate = node.getPredicate();
        if (predicate instanceof True) {
            Node parentNode = this.getParentNode();
            if (parentNode == null) {
                return;
            }
            List parentChildren = parentNode.getNodes();
            if (parentChildren.size() != 1) {
                return;
            }
            boolean success = parentChildren.remove(node);
            if (!success) {
                throw new IllegalArgumentException();
            }
            if (MiningFunction.REGRESSION.equals((Object)this.miningFunction)) {
                TreeModelFlattener.initScore((Node)parentNode, (Node)node);
            } else if (MiningFunction.CLASSIFICATION.equals((Object)this.miningFunction)) {
                TreeModelFlattener.initScoreDistribution((Node)parentNode, (Node)node);
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void enterTreeModel(TreeModel treeModel) {
        this.miningFunction = treeModel.getMiningFunction();
    }

    public void exitTreeModel(TreeModel treeModel) {
        treeModel.setSplitCharacteristic(TreeModel.SplitCharacteristic.MULTI_SPLIT);
        this.miningFunction = null;
    }

    private static Iterator<Node> getChildren(Node node) {
        Predicate predicate = node.getPredicate();
        if (!(predicate instanceof SimplePredicate)) {
            return null;
        }
        SimplePredicate simplePredicate = (SimplePredicate)predicate;
        if (!TreeModelFlattener.hasOperator((Predicate)simplePredicate, (SimplePredicate.Operator)SimplePredicate.Operator.LESS_OR_EQUAL)) {
            return null;
        }
        if (node.hasNodes()) {
            Node child;
            Predicate childPredicate;
            List children = node.getNodes();
            int endPos = 0;
            Iterator iterator = children.iterator();
            while (iterator.hasNext() && TreeModelFlattener.hasFieldReference((Predicate)(childPredicate = (child = (Node)iterator.next()).getPredicate()), (FieldName)simplePredicate.getField()) && TreeModelFlattener.hasOperator((Predicate)childPredicate, (SimplePredicate.Operator)simplePredicate.getOperator())) {
                ++endPos;
            }
            if (endPos > 0) {
                return children.subList(0, endPos).iterator();
            }
            return null;
        }
        return null;
    }
}

