/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import java.util.Map;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sklearn.ClassDictUtil;
import org.jpmml.sklearn.PyClassDict;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sklearn.HasNumberOfFeatures;

public abstract class Estimator
extends PyClassDict
implements HasNumberOfFeatures {
    private static final Logger logger = LoggerFactory.getLogger(Estimator.class);

    public Estimator(String module, String name) {
        super(module, name);
    }

    public abstract MiningFunction getMiningFunction();

    public abstract boolean isSupervised();

    public abstract Model encodeModel(Schema var1);

    @Override
    public int getNumberOfFeatures() {
        Number nFeatures = (Number)this.get("n_features_");
        if (nFeatures == null) {
            return -1;
        }
        return ValueUtil.asInt((Number)nFeatures);
    }

    public OpType getOpType() {
        return OpType.CONTINUOUS;
    }

    public DataType getDataType() {
        return DataType.DOUBLE;
    }

    public Object getOption(String key, Object defaultValue) {
        Map pmmlOptions = (Map)this.get("pmml_options_");
        if (pmmlOptions != null && pmmlOptions.containsKey(key)) {
            return pmmlOptions.get(key);
        }
        if (this.containsKey(key)) {
            logger.warn("Attribute '" + ClassDictUtil.formatMember(this, "pmml_options_") + "' is not set. Falling back to the surrogate attribute '" + ClassDictUtil.formatMember(this, key) + "'");
            return this.get(key);
        }
        return defaultValue;
    }

    public String getSkLearnVersion() {
        return (String)this.get("_sklearn_version");
    }
}

