/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.ruleset;

import java.util.Collections;
import java.util.List;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.rule_set.Rule;
import org.dmg.pmml.rule_set.RuleSelectionMethod;
import org.dmg.pmml.rule_set.RuleSet;
import org.dmg.pmml.rule_set.RuleSetModel;
import org.dmg.pmml.rule_set.SimpleRule;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.sklearn.PredicateTranslator;
import org.jpmml.sklearn.TupleUtil;
import sklearn.Classifier;

public class RuleSetClassifier
extends Classifier {
    public RuleSetClassifier(String module, String name) {
        super(module, name);
    }

    @Override
    public boolean hasProbabilityDistribution() {
        return false;
    }

    public List<String> getClasses() {
        return Collections.emptyList();
    }

    public RuleSetModel encodeModel(Schema schema) {
        String defaultScore = this.getDefaultScore();
        List<Object[]> rules = this.getRules();
        Label label = schema.getLabel();
        List features = schema.getFeatures();
        RuleSelectionMethod ruleSelectionMethod = new RuleSelectionMethod(RuleSelectionMethod.Criterion.FIRST_HIT);
        RuleSet ruleSet = new RuleSet().addRuleSelectionMethods(new RuleSelectionMethod[]{ruleSelectionMethod});
        if (defaultScore != null) {
            ruleSet.setDefaultConfidence(Double.valueOf(1.0)).setDefaultScore(defaultScore);
        }
        for (Object[] rule : rules) {
            String predicate = TupleUtil.extractElement(rule, 0, String.class);
            String score = TupleUtil.extractElement(rule, 1, String.class);
            SimpleRule simpleRule = new SimpleRule().setPredicate(PredicateTranslator.translate(predicate, features)).setScore(score);
            ruleSet.addRules(new Rule[]{simpleRule});
        }
        RuleSetModel ruleSetModel = new RuleSetModel(MiningFunction.CLASSIFICATION, ModelUtil.createMiningSchema((Label)label), ruleSet);
        return ruleSetModel;
    }

    public String getDefaultScore() {
        return (String)this.get("default_score");
    }

    public List<Object[]> getRules() {
        return this.getTupleList("rules");
    }
}

