/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import java.util.Map;
import net.razorvine.pickle.objects.ClassDict;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Schema;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.PyClassDict;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sklearn.HasNumberOfFeatures;
import sklearn.HasType;

public abstract class Estimator
extends PyClassDict
implements HasNumberOfFeatures,
HasType {
    private static final Logger logger = LoggerFactory.getLogger(Estimator.class);

    public Estimator(String module, String name) {
        super(module, name);
    }

    public abstract MiningFunction getMiningFunction();

    public abstract Model encodeModel(Schema var1);

    @Override
    public int getNumberOfFeatures() {
        if (this.containsKey("n_features_")) {
            return this.getInteger("n_features_");
        }
        return -1;
    }

    @Override
    public OpType getOpType() {
        return OpType.CONTINUOUS;
    }

    @Override
    public DataType getDataType() {
        return DataType.DOUBLE;
    }

    public boolean isSupervised() {
        MiningFunction miningFunction = this.getMiningFunction();
        switch (miningFunction) {
            case CLASSIFICATION: 
            case REGRESSION: {
                return true;
            }
            case CLUSTERING: {
                return false;
            }
        }
        throw new IllegalArgumentException();
    }

    public Object getOption(String key, Object defaultValue) {
        Map<String, ?> pmmlOptions = this.getPMMLOptions();
        if (pmmlOptions != null && pmmlOptions.containsKey(key)) {
            return pmmlOptions.get(key);
        }
        if (this.containsKey(key)) {
            logger.warn("Attribute '" + ClassDictUtil.formatMember((ClassDict)this, (String)"pmml_options_") + "' is not set. Falling back to the surrogate attribute '" + ClassDictUtil.formatMember((ClassDict)this, (String)key) + "'");
            return this.get(key);
        }
        return defaultValue;
    }

    public Map<String, ?> getPMMLOptions() {
        return (Map)this.getOptional("pmml_options_", Map.class);
    }

    public Estimator setPMMLOptions(Map<String, ?> pmmlOptions) {
        this.put("pmml_options_", pmmlOptions);
        return this;
    }

    public String getSkLearnVersion() {
        return this.getOptionalString("_sklearn_version");
    }
}

