/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.List;
import numpy.core.UFunc;
import numpy.core.UFuncUtil;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.Transformer;

public class FunctionTransformer
extends Transformer {
    public FunctionTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        UFunc func = this.getFunc();
        if (func == null) {
            return features;
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            ContinuousFeature continuousFeature = features.get(i).toContinuousFeature();
            DerivedField derivedField = encoder.ensureDerivedField(FeatureUtil.createName((String)func.getName(), (Feature)continuousFeature), OpType.CONTINUOUS, DataType.DOUBLE, () -> UFuncUtil.encodeUFunc((UFunc)func, (Expression)continuousFeature.ref()));
            result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
        }
        return result;
    }

    public UFunc getFunc() {
        return (UFunc)this.getOptional("func", UFunc.class);
    }

    public UFunc getInverseFunc() {
        return (UFunc)this.getOptional("inverse_func", UFunc.class);
    }
}

