/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.decoration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Interval;
import org.dmg.pmml.NumericInfo;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutlierTreatmentMethod;
import org.dmg.pmml.UnivariateStats;
import org.jpmml.converter.Decorator;
import org.jpmml.converter.Feature;
import org.jpmml.converter.OutlierDecorator;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.TransformerUtil;
import sklearn2pmml.decoration.Domain;
import sklearn2pmml.decoration.DomainUtil;

public class ContinuousDomain
extends Domain {
    public ContinuousDomain(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] dataMaxShape;
        int[] dataMinShape;
        Boolean withData = this.getWithData();
        if (withData.booleanValue() && (dataMinShape = this.getDataMinShape())[0] == (dataMaxShape = this.getDataMaxShape())[0]) {
            return dataMinShape[0];
        }
        return -1;
    }

    @Override
    public OpType getOpType() {
        return OpType.CONTINUOUS;
    }

    @Override
    public DataType getDataType() {
        Object dtype = this.getDType();
        if (dtype != null) {
            return TransformerUtil.getDataType(dtype);
        }
        return DataType.DOUBLE;
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Number highValue;
        Number lowValue;
        features = super.encodeFeatures(features, encoder);
        OutlierTreatmentMethod outlierTreatment = DomainUtil.parseOutlierTreatment(this.getOutlierTreatment());
        if (outlierTreatment != null) {
            switch (outlierTreatment) {
                case AS_EXTREME_VALUES: 
                case AS_MISSING_VALUES: {
                    lowValue = this.getLowValue();
                    highValue = this.getHighValue();
                    break;
                }
                default: {
                    lowValue = null;
                    highValue = null;
                    break;
                }
            }
        } else {
            lowValue = null;
            highValue = null;
        }
        Boolean withData = this.getWithData();
        Boolean withStatistics = this.getWithStatistics();
        List<? extends Number> dataMin = null;
        List<? extends Number> dataMax = null;
        if (withData.booleanValue()) {
            dataMin = this.getDataMin();
            dataMax = this.getDataMax();
            ClassDictUtil.checkSize((Collection[])new Collection[]{features, dataMin, dataMax});
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            WildcardFeature wildcardFeature = ContinuousDomain.asWildcardFeature(feature);
            DataField dataField = wildcardFeature.getField();
            if (outlierTreatment != null) {
                encoder.addDecorator(dataField, (Decorator)new OutlierDecorator(outlierTreatment, lowValue, highValue));
            }
            if (withData.booleanValue()) {
                Interval interval = new Interval(Interval.Closure.CLOSED_CLOSED).setLeftMargin(dataMin.get(i)).setRightMargin(dataMax.get(i));
                dataField.addIntervals(new Interval[]{interval});
                feature = wildcardFeature.toContinuousFeature();
            }
            if (withStatistics.booleanValue()) {
                Map<String, ?> counts = ContinuousDomain.extractMap(this.getCounts(), i);
                Map<String, ?> numericInfo = ContinuousDomain.extractMap(this.getNumericInfo(), i);
                UnivariateStats univariateStats = new UnivariateStats().setField(dataField.getName()).setCounts(ContinuousDomain.createCounts(counts)).setNumericInfo(ContinuousDomain.createNumericInfo(wildcardFeature.getDataType(), numericInfo));
                encoder.putUnivariateStats(univariateStats);
            }
            result.add(feature);
        }
        return result;
    }

    public String getOutlierTreatment() {
        return this.getOptionalString("outlier_treatment");
    }

    public Number getLowValue() {
        return this.getNumber("low_value");
    }

    public Number getHighValue() {
        return this.getNumber("high_value");
    }

    public List<? extends Number> getDataMin() {
        return this.getNumberArray("data_min_");
    }

    public int[] getDataMinShape() {
        return this.getArrayShape("data_min_", 1);
    }

    public List<? extends Number> getDataMax() {
        return this.getNumberArray("data_max_");
    }

    public int[] getDataMaxShape() {
        return this.getArrayShape("data_max_", 1);
    }

    public Map<String, ?> getNumericInfo() {
        return (Map)this.get("numeric_info_", Map.class);
    }

    public static NumericInfo createNumericInfo(DataType dataType, Map<String, ?> values) {
        NumericInfo numericInfo = new NumericInfo().setMinimum(ContinuousDomain.selectValue(values, "minimum")).setMaximum(ContinuousDomain.selectValue(values, "maximum")).setMean(ContinuousDomain.selectValue(values, "mean")).setStandardDeviation(ContinuousDomain.selectValue(values, "standardDeviation")).setMedian(ContinuousDomain.selectValue(values, "median")).setInterQuartileRange(ContinuousDomain.selectValue(values, "interQuartileRange"));
        return numericInfo;
    }
}

