/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.pipeline;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import h2o.estimators.BaseEstimator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.razorvine.pickle.objects.ClassDict;
import numpy.core.NDArray;
import numpy.core.ScalarUtil;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningBuildTask;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.Value;
import org.dmg.pmml.VerificationField;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.converter.CMatrixUtil;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ContinuousLabel;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.Schema;
import org.jpmml.converter.TypeUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.converter.visitors.AbstractExtender;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.PyClassDict;
import org.jpmml.sklearn.SkLearnEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sklearn.Classifier;
import sklearn.ClassifierUtil;
import sklearn.Estimator;
import sklearn.HasNumberOfFeatures;
import sklearn.Initializer;
import sklearn.Transformer;
import sklearn.TransformerUtil;
import sklearn.pipeline.Pipeline;
import sklearn2pmml.decoration.Domain;
import sklearn2pmml.pipeline.Verification;

public class PMMLPipeline
extends Pipeline {
    private static final Logger logger = LoggerFactory.getLogger(PMMLPipeline.class);

    public PMMLPipeline() {
        this("sklearn2pmml", "PMMLPipeline");
    }

    public PMMLPipeline(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        logger.warn(ClassDictUtil.formatClass((Object)this) + " should be replaced with " + ClassDictUtil.formatClass((Object)new Pipeline()) + " in nested workflows");
        return super.encodeFeatures(features, encoder);
    }

    /*
     * WARNING - void declaration
     */
    public PMML encodePMML() {
        List<? extends Transformer> transformers = this.getTransformers();
        Estimator estimator = null;
        if (this.hasFinalEstimator()) {
            estimator = this.getFinalEstimator();
        }
        Transformer predictTransformer = this.getPredictTransformer();
        Transformer predictProbaTransformer = this.getPredictProbaTransformer();
        Transformer applyTransformer = this.getApplyTransformer();
        List<String> activeFields = this.getActiveFields();
        List<String> probabilityFields = null;
        List<String> targetFields = this.getTargetFields();
        String repr = this.getRepr();
        Verification verification = this.getVerification();
        SkLearnEncoder encoder = new SkLearnEncoder();
        ContinuousLabel label = null;
        if (estimator != null && estimator.isSupervised()) {
            if (targetFields == null) {
                targetFields = this.initTargetFields();
            }
            ClassDictUtil.checkSize((int)1, (Collection[])new Collection[]{targetFields});
            String targetField = targetFields.get(0);
            MiningFunction miningFunction = estimator.getMiningFunction();
            switch (miningFunction) {
                case CLASSIFICATION: {
                    List<?> categories = ClassifierUtil.getClasses(estimator);
                    Map classExtensions = (Map)estimator.getOption("class_extensions", null);
                    DataType dataType = TypeUtil.getDataType(categories, (DataType)DataType.STRING);
                    DataField dataField = encoder.createDataField(FieldName.create((String)targetField), OpType.CATEGORICAL, dataType, categories);
                    ArrayList<1> visitors = new ArrayList<1>();
                    if (classExtensions != null) {
                        Set entries = classExtensions.entrySet();
                        Iterator iterator = entries.iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry = (Map.Entry)iterator.next();
                            String name = (String)entry.getKey();
                            final Map values = (Map)entry.getValue();
                            AbstractExtender valueExtender = new AbstractExtender(name){

                                public VisitorAction visit(Value pmmlValue) {
                                    Object value = values.get(pmmlValue.getValue());
                                    if (value != null) {
                                        value = ScalarUtil.decode(value);
                                        this.addExtension((PMMLObject)pmmlValue, ValueUtil.asString(value));
                                    }
                                    return super.visit(pmmlValue);
                                }
                            };
                            visitors.add(valueExtender);
                        }
                    }
                    for (Visitor visitor : visitors) {
                        visitor.applyTo((Visitable)dataField);
                    }
                    label = new CategoricalLabel(dataField);
                    break;
                }
                case REGRESSION: {
                    DataField dataField = encoder.createDataField(FieldName.create((String)targetField), OpType.CONTINUOUS, DataType.DOUBLE);
                    label = new ContinuousLabel(dataField);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        List<Feature> features = new ArrayList<Feature>();
        PyClassDict featureInitializer = estimator;
        try {
            Transformer transformer = TransformerUtil.getHead(transformers);
            if (transformer != null) {
                featureInitializer = transformer;
                if (!(transformer instanceof Initializer)) {
                    if (activeFields == null) {
                        activeFields = this.initActiveFields(transformer);
                    }
                    features = PMMLPipeline.initFeatures(activeFields, transformer.getOpType(), transformer.getDataType(), encoder);
                }
                features = super.encodeFeatures(features, encoder);
            } else if (estimator != null) {
                if (activeFields == null) {
                    activeFields = this.initActiveFields(estimator);
                }
                features = PMMLPipeline.initFeatures(activeFields, estimator.getOpType(), estimator.getDataType(), encoder);
            }
        }
        catch (UnsupportedOperationException uoe) {
            throw new IllegalArgumentException("The transformer object of the first step (" + ClassDictUtil.formatClass((Object)featureInitializer) + ") does not specify feature type information", uoe);
        }
        if (estimator == null) {
            return this.encodePMML(null, repr, encoder);
        }
        int numberOfFeatures = estimator.getNumberOfFeatures();
        if (numberOfFeatures != -1) {
            ClassDictUtil.checkSize((int)numberOfFeatures, (Collection[])new Collection[]{features});
        }
        Schema schema = new Schema(label, features);
        Model model = estimator.encodeModel(schema);
        if (predictTransformer != null || predictProbaTransformer != null || applyTransformer != null) {
            Model finalModel = MiningModelUtil.getFinalModel((Model)model);
            Output output = ModelUtil.ensureOutput((Model)finalModel);
            if (predictTransformer != null) {
                void var21_28;
                FieldName name = FieldName.create((String)("predict(" + label.getName().getValue() + ")"));
                if (label instanceof ContinuousLabel) {
                    OutputField outputField = ModelUtil.createPredictedField((FieldName)name, (OpType)OpType.CONTINUOUS, (DataType)label.getDataType()).setFinalResult(Boolean.valueOf(false));
                } else if (label instanceof CategoricalLabel) {
                    OutputField outputField = ModelUtil.createPredictedField((FieldName)name, (OpType)OpType.CATEGORICAL, (DataType)label.getDataType()).setFinalResult(Boolean.valueOf(false));
                } else {
                    throw new IllegalArgumentException();
                }
                output.addOutputFields(new OutputField[]{var21_28});
                this.encodeOutput(output, Collections.singletonList(var21_28), predictTransformer, encoder);
            }
            if (predictProbaTransformer != null) {
                CategoricalLabel categoricalLabel = (CategoricalLabel)label;
                List list = ModelUtil.createProbabilityFields((DataType)DataType.DOUBLE, (List)categoricalLabel.getValues());
                this.encodeOutput(output, list, predictProbaTransformer, encoder);
            }
            if (applyTransformer != null) {
                OutputField nodeIdField = ModelUtil.createEntityIdField((FieldName)FieldName.create((String)"nodeId")).setDataType(DataType.INTEGER);
                this.encodeOutput(output, Collections.singletonList(nodeIdField), applyTransformer, encoder);
            }
        }
        if (estimator.isSupervised()) {
            if (verification == null) {
                logger.warn("Model verification data is not set. Use method '" + ClassDictUtil.formatMember((ClassDict)this, (String)"verify(X)") + "' to correct this deficiency");
            } else {
                VerificationField verificationField;
                int i;
                int[] activeValuesShape = verification.getActiveValuesShape();
                int[] targetValuesShape = verification.getTargetValuesShape();
                ClassDictUtil.checkShapes((int)0, (int[][])new int[][]{activeValuesShape, targetValuesShape});
                ClassDictUtil.checkShapes((int)1, (int)activeFields.size(), (int[][])new int[][]{activeValuesShape});
                List<?> activeValues = verification.getActiveValues();
                List<?> list = verification.getTargetValues();
                int[] probabilityValuesShape = null;
                List<? extends Number> probabilityValues = null;
                boolean hasProbabilityValues = verification.hasProbabilityValues();
                if (estimator instanceof BaseEstimator) {
                    BaseEstimator baseEstimator = (BaseEstimator)estimator;
                    hasProbabilityValues &= baseEstimator.hasProbabilityDistribution();
                } else if (estimator instanceof Classifier) {
                    Classifier classifier = (Classifier)estimator;
                    hasProbabilityValues &= classifier.hasProbabilityDistribution();
                } else {
                    hasProbabilityValues = false;
                }
                if (hasProbabilityValues) {
                    probabilityFields = this.initProbabilityFields((CategoricalLabel)label);
                    probabilityValuesShape = verification.getProbabilityValuesShape();
                    ClassDictUtil.checkShapes((int)0, (int[][])new int[][]{activeValuesShape, probabilityValuesShape});
                    ClassDictUtil.checkShapes((int)1, (int)probabilityFields.size(), (int[][])new int[][]{probabilityValuesShape});
                    probabilityValues = verification.getProbabilityValues();
                }
                Number precision = verification.getPrecision();
                Number zeroThreshold = verification.getZeroThreshold();
                int rows = activeValuesShape[0];
                LinkedHashMap<VerificationField, List> data = new LinkedHashMap<VerificationField, List>();
                if (activeFields != null) {
                    for (i = 0; i < activeFields.size(); ++i) {
                        verificationField = ModelUtil.createVerificationField((FieldName)FieldName.create((String)activeFields.get(i)));
                        Domain domain = encoder.getDomain(verificationField.getField());
                        data.put(verificationField, CMatrixUtil.getColumn(PMMLPipeline.cleanValues(domain, activeValues), (int)rows, (int)activeFields.size(), (int)i));
                    }
                }
                if (probabilityFields != null) {
                    for (i = 0; i < probabilityFields.size(); ++i) {
                        verificationField = ModelUtil.createVerificationField((FieldName)FieldName.create((String)probabilityFields.get(i))).setPrecision(precision).setZeroThreshold(zeroThreshold);
                        data.put(verificationField, CMatrixUtil.getColumn(PMMLPipeline.cleanValues(null, probabilityValues), (int)rows, (int)probabilityFields.size(), (int)i));
                    }
                } else {
                    for (i = 0; i < targetFields.size(); ++i) {
                        verificationField = ModelUtil.createVerificationField((FieldName)FieldName.create((String)targetFields.get(i)));
                        DataType dataType = label.getDataType();
                        switch (dataType) {
                            case DOUBLE: 
                            case FLOAT: {
                                verificationField.setPrecision(precision).setZeroThreshold(zeroThreshold);
                                break;
                            }
                        }
                        Domain domain = encoder.getDomain(verificationField.getField());
                        data.put(verificationField, CMatrixUtil.getColumn(PMMLPipeline.cleanValues(domain, list), (int)rows, (int)targetFields.size(), (int)i));
                    }
                }
                model.setModelVerification(ModelUtil.createModelVerification(data));
            }
        }
        return this.encodePMML(model, repr, encoder);
    }

    private PMML encodePMML(Model model, String repr, SkLearnEncoder encoder) {
        PMML pmml = encoder.encodePMML(model);
        if (repr != null) {
            Extension extension = new Extension().addContent(new Object[]{repr});
            MiningBuildTask miningBuildTask = new MiningBuildTask().addExtensions(new Extension[]{extension});
            pmml.setMiningBuildTask(miningBuildTask);
        }
        return pmml;
    }

    private void encodeOutput(Output output, List<OutputField> outputFields, Transformer transformer, SkLearnEncoder encoder) {
        SkLearnEncoder outputEncoder = new SkLearnEncoder();
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (OutputField outputField : outputFields) {
            DataField dataField = outputEncoder.createDataField(outputField.getName(), outputField.getOpType(), outputField.getDataType());
            features.add((Feature)new WildcardFeature((PMMLEncoder)outputEncoder, dataField));
        }
        transformer.encodeFeatures(features, outputEncoder);
        Map derivedFields = outputEncoder.getDerivedFields();
        for (DerivedField derivedField : derivedFields.values()) {
            OutputField outputField = new OutputField(derivedField.getName(), derivedField.getOpType(), derivedField.getDataType()).setResultFeature(ResultFeature.TRANSFORMED_VALUE).setExpression(derivedField.getExpression());
            output.addOutputFields(new OutputField[]{outputField});
        }
        Map map = outputEncoder.getDefineFunctions();
        for (DefineFunction defineFunction : map.values()) {
            encoder.addDefineFunction(defineFunction);
        }
    }

    @Override
    public List<Object[]> getSteps() {
        return super.getSteps();
    }

    public PMMLPipeline setSteps(List<Object[]> steps) {
        this.put("steps", steps);
        return this;
    }

    public Transformer getPredictTransformer() {
        return this.getTransformer("predict_transformer");
    }

    public Transformer getPredictProbaTransformer() {
        return this.getTransformer("predict_proba_transformer");
    }

    public Transformer getApplyTransformer() {
        return this.getTransformer("apply_transformer");
    }

    private Transformer getTransformer(String key) {
        return (Transformer)this.getOptional(key, Transformer.class);
    }

    public List<String> getActiveFields() {
        if (!this.containsKey("active_fields")) {
            return null;
        }
        return this.getListLike("active_fields", String.class);
    }

    public PMMLPipeline setActiveFields(List<String> activeFields) {
        this.put("active_fields", PMMLPipeline.toArray(activeFields));
        return this;
    }

    public List<String> getTargetFields() {
        if (this.containsKey("target_field")) {
            return Collections.singletonList(this.getOptionalString("target_field"));
        }
        if (!this.containsKey("target_fields")) {
            return null;
        }
        return this.getListLike("target_fields", String.class);
    }

    public PMMLPipeline setTargetFields(List<String> targetFields) {
        this.put("target_fields", PMMLPipeline.toArray(targetFields));
        return this;
    }

    public String getRepr() {
        return this.getOptionalString("repr_");
    }

    public PMMLPipeline setRepr(String repr) {
        this.put("repr_", repr);
        return this;
    }

    public Verification getVerification() {
        return (Verification)((Object)this.getOptional("verification", Verification.class));
    }

    public PMMLPipeline setVerification(Verification verification) {
        this.put("verification", (Object)verification);
        return this;
    }

    private List<String> initActiveFields(PyClassDict object) {
        int numberOfFeatures = -1;
        if (object instanceof HasNumberOfFeatures) {
            HasNumberOfFeatures hasNumberOfFeatures = (HasNumberOfFeatures)object;
            numberOfFeatures = hasNumberOfFeatures.getNumberOfFeatures();
        }
        if (numberOfFeatures == -1) {
            throw new IllegalArgumentException("The transformer object of the first step (" + ClassDictUtil.formatClass((Object)object) + ") does not specify the number of input features");
        }
        ArrayList<String> activeFields = new ArrayList<String>(numberOfFeatures);
        int max = numberOfFeatures;
        for (int i = 0; i < max; ++i) {
            activeFields.add("x" + String.valueOf(i + 1));
        }
        logger.warn("Attribute '" + ClassDictUtil.formatMember((ClassDict)this, (String)"active_fields") + "' is not set. Assuming {} as the names of active fields", activeFields);
        return activeFields;
    }

    private List<String> initProbabilityFields(CategoricalLabel categoricalLabel) {
        ArrayList<String> probabilityFields = new ArrayList<String>();
        List values = categoricalLabel.getValues();
        for (Object value : values) {
            probabilityFields.add("probability(" + value + ")");
        }
        return probabilityFields;
    }

    private List<String> initTargetFields() {
        String targetField = "y";
        logger.warn("Attribute '" + ClassDictUtil.formatMember((ClassDict)this, (String)"target_fields") + "' is not set. Assuming {} as the name of the target field", (Object)targetField);
        return Collections.singletonList(targetField);
    }

    private static List<Feature> initFeatures(List<String> activeFields, OpType opType, DataType dataType, SkLearnEncoder encoder) {
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (String activeField : activeFields) {
            DataField dataField = encoder.createDataField(FieldName.create((String)activeField), opType, dataType);
            result.add((Feature)new WildcardFeature((PMMLEncoder)encoder, dataField));
        }
        return result;
    }

    private static List<?> cleanValues(Domain domain, List<?> values) {
        final HashSet<Number> missingValues = new HashSet<Number>();
        missingValues.add(Float.valueOf(Float.NaN));
        missingValues.add(Double.NaN);
        Function<Object, Object> function = new Function<Object, Object>(){

            public Object apply(Object value) {
                if (missingValues.contains(value)) {
                    return null;
                }
                return value;
            }
        };
        return Lists.transform(values, (Function)function);
    }

    private static NDArray toArray(List<String> strings) {
        NDArray result = new NDArray();
        result.put((Object)"data", strings);
        result.put((Object)"fortran_order", (Object)Boolean.FALSE);
        return result;
    }
}

