/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sklearn;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.dmg.pmml.PMML;
import org.jpmml.model.metro.MetroJAXBUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.PickleUtil;
import org.jpmml.python.Storage;
import org.jpmml.sklearn.SkLearnEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sklearn.Estimator;
import sklearn.pipeline.Pipeline;
import sklearn2pmml.pipeline.PMMLPipeline;

public class Main {
    @Parameter(names={"--help"}, description="Show the list of configuration options and exit", help=true)
    private boolean help = false;
    @Parameter(names={"--pkl-pipeline-input", "--pkl-input"}, description="Pickle input file", required=true)
    private File input = null;
    @Parameter(names={"--pmml-output"}, description="PMML output file", required=true)
    private File output = null;
    @Parameter(names={"-X-compact"}, arity=1, hidden=true)
    private Boolean compact = null;
    @Parameter(names={"-X-flat"}, arity=1, hidden=true)
    private Boolean flat = null;
    @Parameter(names={"-X-node_id"}, arity=1, hidden=true)
    private Boolean nodeId = null;
    @Parameter(names={"-X-node_score"}, arity=1, hidden=true)
    private Boolean nodeScore = null;
    @Parameter(names={"-X-winner_id"}, arity=1, hidden=true)
    private Boolean winnerId = null;
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String ... args) throws Exception {
        Main main = new Main();
        JCommander commander = new JCommander((Object)main);
        commander.setProgramName(Main.class.getName());
        try {
            commander.parse(args);
        }
        catch (ParameterException pe) {
            StringBuilder sb = new StringBuilder();
            sb.append(pe.toString());
            sb.append("\n");
            commander.usage(sb);
            System.err.println(sb.toString());
            System.exit(-1);
        }
        if (main.help) {
            StringBuilder sb = new StringBuilder();
            commander.usage(sb);
            System.out.println(sb.toString());
            System.exit(0);
        }
        main.run();
    }

    public void run() throws Exception {
        PMML pmml;
        Pipeline pipeline;
        long end;
        Object object;
        long begin;
        SkLearnEncoder encoder = new SkLearnEncoder();
        try (Storage storage = PickleUtil.createStorage((File)this.input);){
            logger.info("Parsing PKL..");
            begin = System.currentTimeMillis();
            object = PickleUtil.unpickle((Storage)storage);
            end = System.currentTimeMillis();
            logger.info("Parsed PKL in {} ms.", (Object)(end - begin));
        }
        catch (Exception e) {
            logger.error("Failed to parse PKL", (Throwable)e);
            throw e;
        }
        if (!(object instanceof PMMLPipeline)) {
            if (object instanceof Pipeline) {
                pipeline = (Pipeline)object;
                object = new PMMLPipeline().setSteps(pipeline.getSteps());
            } else if (object instanceof Estimator) {
                Estimator estimator = (Estimator)object;
                object = new PMMLPipeline().setSteps(Collections.singletonList(new Object[]{"estimator", estimator}));
            } else {
                throw new IllegalArgumentException("The object (" + ClassDictUtil.formatClass((Object)object) + ") is not a PMMLPipeline");
            }
        }
        if ((pipeline = (PMMLPipeline)object).hasFinalEstimator()) {
            Estimator estimator = pipeline.getFinalEstimator();
            LinkedHashMap<String, Boolean> options = new LinkedHashMap<String, Boolean>();
            options.put("compact", this.compact);
            options.put("flat", this.flat);
            options.put("node_id", this.nodeId);
            options.put("node_score", this.nodeScore);
            options.put("winner_id", this.winnerId);
            options.values().removeIf(Objects::isNull);
            if (!options.isEmpty()) {
                Map<String, ?> pmmlOptions = estimator.getPMMLOptions();
                if (pmmlOptions == null) {
                    pmmlOptions = new LinkedHashMap();
                    estimator.setPMMLOptions(pmmlOptions);
                }
                pmmlOptions.putAll(options);
            }
        }
        try {
            logger.info("Converting PKL to PMML..");
            begin = System.currentTimeMillis();
            pmml = ((PMMLPipeline)pipeline).encodePMML(encoder);
            end = System.currentTimeMillis();
            logger.info("Converted PKL to PMML in {} ms.", (Object)(end - begin));
        }
        catch (Exception e) {
            logger.error("Failed to convert PKL to PMML", (Throwable)e);
            throw e;
        }
        try (FileOutputStream os = new FileOutputStream(this.output);){
            logger.info("Marshalling PMML..");
            long begin2 = System.currentTimeMillis();
            MetroJAXBUtil.marshalPMML((PMML)pmml, (OutputStream)os);
            long end2 = System.currentTimeMillis();
            logger.info("Marshalled PMML in {} ms.", (Object)(end2 - begin2));
        }
        catch (Exception e) {
            logger.error("Failed to marshal PMML", (Throwable)e);
            throw e;
        }
    }

    public File getInput() {
        return this.input;
    }

    public void setInput(File input) {
        this.input = input;
    }

    public File getOutput() {
        return this.output;
    }

    public void setOutput(File output) {
        this.output = output;
    }
}

