/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sklearn;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import numpy.DType;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.python.PickleUtil;
import org.jpmml.python.PythonEncoder;
import sklearn.ensemble.hist_gradient_boosting.TreePredictor;
import sklearn.neighbors.BinaryTree;
import sklearn.tree.Tree;
import sklearn2pmml.decoration.Alias;
import sklearn2pmml.decoration.Domain;

public class SkLearnEncoder
extends PythonEncoder {
    private Map<FieldName, Domain> domains = new LinkedHashMap<FieldName, Domain>();

    public DataField createDataField(FieldName name) {
        return this.createDataField(name, OpType.CONTINUOUS, DataType.DOUBLE);
    }

    public DerivedField createDerivedField(FieldName name, Expression expression) {
        return this.createDerivedField(name, OpType.CONTINUOUS, DataType.DOUBLE, expression);
    }

    public void addDerivedField(DerivedField derivedField) {
        try {
            super.addDerivedField(derivedField);
        }
        catch (RuntimeException re) {
            FieldName name = derivedField.getName();
            String message = "Field " + name.getValue() + " is already defined. Please refactor the pipeline so that it would not contain duplicate field declarations, or use the " + Alias.class.getName() + " wrapper class to override the default name with a custom name (eg. " + Alias.formatAliasExample() + ")";
            throw new IllegalArgumentException(message, re);
        }
    }

    public void renameFeature(Feature feature, FieldName renamedName) {
        FieldName name = feature.getName();
        org.dmg.pmml.Field pmmlField = this.getField(name);
        if (pmmlField instanceof DataField) {
            throw new IllegalArgumentException("User input field " + name.getValue() + " cannot be renamed");
        }
        DerivedField derivedField = this.removeDerivedField(name);
        try {
            Field field = Feature.class.getDeclaredField("name");
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(feature, renamedName);
        }
        catch (ReflectiveOperationException roe) {
            throw new RuntimeException(roe);
        }
        derivedField.setName(renamedName);
        this.addDerivedField(derivedField);
    }

    public boolean isFrozen(FieldName name) {
        return this.domains.containsKey(name);
    }

    public Domain getDomain(FieldName name) {
        return this.domains.get(name);
    }

    public void setDomain(FieldName name, Domain domain) {
        if (domain != null) {
            this.domains.put(name, domain);
        } else {
            this.domains.remove(name);
        }
    }

    static {
        PickleUtil.init((String)"sklearn2pmml.properties");
        DType.addDefinition(BinaryTree.DTYPE_NODEDATA);
        DType.addDefinition(Tree.DTYPE_TREE);
        DType.addDefinition(TreePredictor.DTYPE_PREDICTOR_OLD);
        DType.addDefinition(TreePredictor.DTYPE_PREDICTOR_NEW);
    }
}

