/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import java.util.ArrayList;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ObjectFeature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.StringFeature;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.StepUtil;
import sklearn.Transformer;

public class CastTransformer
extends Transformer {
    public CastTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Object dtype = this.getDType();
        OpType opType = StepUtil.getOpType(dtype);
        DataType dataType = StepUtil.getDataType(dtype);
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            if (!dataType.equals((Object)feature.getDataType())) {
                FieldRef fieldRef = feature.ref();
                DerivedField derivedField = encoder.ensureDerivedField(this.createFieldName(dataType.name().toLowerCase(), feature), opType, dataType, () -> fieldRef);
                switch (dataType) {
                    case STRING: {
                        feature = new StringFeature((PMMLEncoder)encoder, (Field)derivedField);
                        break;
                    }
                    case INTEGER: 
                    case FLOAT: 
                    case DOUBLE: {
                        feature = new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField);
                        break;
                    }
                    default: {
                        feature = new ObjectFeature((PMMLEncoder)encoder, (Field)derivedField);
                    }
                }
            }
            result.add(feature);
        }
        return result;
    }

    public Object getDType() {
        return this.getDType(true);
    }
}

