/*
 * Decompiled with CFR 0.152.
 */
package category_encoders;

import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.NormDiscrete;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.HasDerivedName;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;

public abstract class BaseNFeature
extends Feature
implements HasDerivedName {
    private int base = -1;
    private SetMultimap<Integer, ?> values = null;

    public BaseNFeature(PMMLEncoder encoder, Field<?> field, int base, SetMultimap<Integer, ?> values) {
        this(encoder, field.getName(), field.getDataType(), base, values);
    }

    public BaseNFeature(PMMLEncoder encoder, Feature feature, int base, SetMultimap<Integer, ?> values) {
        this(encoder, feature.getName(), feature.getDataType(), base, values);
    }

    public BaseNFeature(PMMLEncoder encoder, FieldName name, DataType dataType, int base, SetMultimap<Integer, ?> values) {
        super(encoder, name, dataType);
        this.setBase(base);
        this.setValues(values);
    }

    public ContinuousFeature toContinuousFeature() {
        FieldName name = this.getName();
        DataType dataType = this.getDataType();
        int base = this.getBase();
        SetMultimap<Integer, ?> values = this.getValues();
        Supplier<Expression> expressionSupplier = () -> {
            Collection categories;
            Map valueMap = values.asMap();
            if (base == 2 && (categories = (Collection)valueMap.get(1)) != null && categories.size() == 1) {
                Object category = Iterables.getOnlyElement((Iterable)categories);
                return new NormDiscrete(name, category);
            }
            Apply apply = null;
            Apply prevIfApply = null;
            Set entries = valueMap.entrySet();
            for (Map.Entry entry : entries) {
                Integer baseValue = (Integer)entry.getKey();
                Collection categories2 = (Collection)entry.getValue();
                Apply valueApply = PMMLUtil.createApply((String)(categories2.size() == 1 ? "equal" : "isIn"), (Expression[])new Expression[]{new FieldRef(name)});
                for (Object category : categories2) {
                    valueApply.addExpressions(new Expression[]{PMMLUtil.createConstant(category, (DataType)dataType)});
                }
                Apply ifApply = PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{valueApply}).addExpressions(new Expression[]{PMMLUtil.createConstant((Number)baseValue)});
                if (apply == null) {
                    apply = ifApply;
                }
                if (prevIfApply != null) {
                    prevIfApply.addExpressions(new Expression[]{ifApply});
                }
                prevIfApply = ifApply;
            }
            if (apply == null) {
                return PMMLUtil.createConstant((Number)0);
            }
            prevIfApply.addExpressions(new Expression[]{PMMLUtil.createConstant((Number)0)});
            return apply;
        };
        return this.toContinuousFeature(this.getDerivedName(), DataType.INTEGER, expressionSupplier);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.getBase());
        result = 31 * result + Objects.hash(this.getValues());
        return result;
    }

    public boolean equals(Object object) {
        if (object instanceof BaseNFeature) {
            BaseNFeature that = (BaseNFeature)((Object)object);
            return super.equals(object) && Objects.equals(this.getBase(), that.getBase()) && Objects.equals(this.getValues(), that.getValues());
        }
        return false;
    }

    public int getBase() {
        return this.base;
    }

    private void setBase(int base) {
        this.base = base;
    }

    public SetMultimap<Integer, ?> getValues() {
        return this.values;
    }

    private void setValues(SetMultimap<Integer, ?> values) {
        this.values = Objects.requireNonNull(values);
    }
}

