/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import java.util.List;
import numpy.DType;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import sklearn.HasNumberOfFeatures;
import sklearn.Transformer;
import sklearn.pipeline.FeatureUnion;
import sklearn.pipeline.Pipeline;
import sklearn.pipeline.PipelineTransformer;

public class TransformerUtil {
    private TransformerUtil() {
    }

    public static int getNumberOfFeatures(Transformer transformer) {
        if (transformer instanceof HasNumberOfFeatures) {
            HasNumberOfFeatures hasNumberOfFeatures = (HasNumberOfFeatures)((Object)transformer);
            return hasNumberOfFeatures.getNumberOfFeatures();
        }
        return -1;
    }

    public static OpType getOpType(DataType dataType) {
        switch (dataType) {
            case STRING: {
                return OpType.CATEGORICAL;
            }
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: {
                return OpType.CONTINUOUS;
            }
            case BOOLEAN: {
                return OpType.CATEGORICAL;
            }
            case DATE: 
            case DATE_TIME: {
                return OpType.ORDINAL;
            }
        }
        throw new IllegalArgumentException();
    }

    public static OpType getOpType(Object dtype) {
        DataType dataType = TransformerUtil.getDataType(dtype);
        return TransformerUtil.getOpType(dataType);
    }

    public static DataType getDataType(Object dtype) {
        if (dtype instanceof String) {
            String stringDType = (String)dtype;
            return TransformerUtil.parseDataType(stringDType);
        }
        DType numpyDType = (DType)dtype;
        return numpyDType.getDataType();
    }

    public static DataType parseDataType(String dtype) {
        switch (dtype) {
            case "datetime64[D]": {
                return DataType.DATE;
            }
            case "datetime64[s]": {
                return DataType.DATE_TIME;
            }
        }
        throw new IllegalArgumentException(dtype);
    }

    public static Transformer getHead(List<? extends Transformer> transformers) {
        while (transformers.size() > 0) {
            Transformer transformer = transformers.get(0);
            if (transformer instanceof FeatureUnion) {
                FeatureUnion featureUnion = (FeatureUnion)transformer;
                transformers = featureUnion.getTransformers();
                continue;
            }
            if (transformer instanceof PipelineTransformer) {
                PipelineTransformer pipelineTransformer = (PipelineTransformer)transformer;
                Pipeline pipeline = pipelineTransformer.getPipeline();
                transformers = pipeline.getTransformers();
                continue;
            }
            return transformer;
        }
        return null;
    }
}

