/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import java.util.ArrayList;
import java.util.List;
import net.razorvine.pickle.objects.ClassDictConstructor;
import numpy.DType;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.python.ClassDictConstructorUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.HasType;
import sklearn.Step;
import sklearn.StepUtil;

public abstract class Transformer
extends Step
implements HasType {
    public Transformer(String module, String name) {
        super(module, name);
    }

    public abstract List<Feature> encodeFeatures(List<Feature> var1, SkLearnEncoder var2);

    @Override
    public OpType getOpType() {
        return OpType.CONTINUOUS;
    }

    @Override
    public DataType getDataType() {
        return DataType.DOUBLE;
    }

    public List<Feature> updateAndEncodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        StepUtil.checkNumberOfFeatures(this, features);
        features = this.updateFeatures(features, encoder);
        return this.encodeFeatures(features, encoder);
    }

    public List<Feature> updateFeatures(List<Feature> features, SkLearnEncoder encoder) {
        DataType dataType;
        OpType opType;
        try {
            opType = this.getOpType();
            dataType = this.getDataType();
        }
        catch (UnsupportedOperationException uoe) {
            return features;
        }
        ArrayList<Feature> result = new ArrayList<Feature>(features.size());
        for (Feature feature : features) {
            if (feature instanceof WildcardFeature) {
                WildcardFeature wildcardFeature = (WildcardFeature)feature;
                FieldName name = wildcardFeature.getName();
                DataField dataField = encoder.getDataField(name);
                if (dataField == null) {
                    throw new IllegalArgumentException("Field " + name.getValue() + " is undefined");
                }
                dataField = this.updateDataField(dataField, opType, dataType, encoder);
                feature = new WildcardFeature((PMMLEncoder)encoder, dataField);
            }
            result.add(feature);
        }
        return result;
    }

    public DataField updateDataField(DataField dataField, OpType opType, DataType dataType, SkLearnEncoder encoder) {
        FieldName name = dataField.getName();
        if (encoder.isFrozen(name)) {
            return dataField;
        }
        switch (dataType) {
            case DOUBLE: {
                if (DataType.DOUBLE.equals((Object)dataField.getDataType())) break;
                dataType = dataField.getDataType();
            }
        }
        dataField.setOpType(opType).setDataType(dataType);
        return dataField;
    }

    protected Object getDType(boolean extended) {
        Object dtype = this.get("dtype");
        if (dtype instanceof String) {
            String string = (String)dtype;
            if (extended) {
                return string;
            }
        } else if (dtype instanceof ClassDictConstructor) {
            ClassDictConstructor dictConstructor = (ClassDictConstructor)dtype;
            return ClassDictConstructorUtil.construct((ClassDictConstructor)dictConstructor, DType.class);
        }
        return this.get("dtype", DType.class);
    }
}

