/*
 * Decompiled with CFR 0.152.
 */
package sklearn.decomposition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.jpmml.converter.CMatrixUtil;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.FieldNameUtil;
import sklearn.decomposition.BasePCA;

public class PCA
extends BasePCA {
    public PCA(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        int[] shape = this.getComponentsShape();
        int numberOfComponents = shape[0];
        int numberOfFeatures = shape[1];
        List<? extends Number> components = this.getComponents();
        List<? extends Number> mean = this.getMean();
        ClassDictUtil.checkSize((int)numberOfFeatures, (Collection[])new Collection[]{features, mean});
        Boolean whiten = this.getWhiten();
        List<? extends Number> explainedVariance = whiten != false ? this.getExplainedVariance() : null;
        ClassDictUtil.checkSize((int)numberOfComponents, (Collection[])new Collection[]{explainedVariance});
        FieldName name = this.createFieldName("pca", features);
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < numberOfComponents; ++i) {
            Number explainedVarianceValue;
            List component = CMatrixUtil.getRow(components, (int)numberOfComponents, (int)numberOfFeatures, (int)i);
            Apply apply = PMMLUtil.createApply((String)"sum", (Expression[])new Expression[0]);
            for (int j = 0; j < numberOfFeatures; ++j) {
                Feature feature = features.get(j);
                Number meanValue = mean.get(j);
                Number componentValue = (Number)component.get(j);
                if (ValueUtil.isZero((Number)meanValue) && ValueUtil.isOne((Number)componentValue)) {
                    apply.addExpressions(new Expression[]{feature.ref()});
                    continue;
                }
                ContinuousFeature continuousFeature = feature.toContinuousFeature();
                FieldRef expression = continuousFeature.ref();
                if (!ValueUtil.isZero((Number)meanValue)) {
                    expression = PMMLUtil.createApply((String)"-", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Number)meanValue)});
                }
                if (!ValueUtil.isOne((Number)componentValue)) {
                    expression = PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Number)componentValue)});
                }
                apply.addExpressions(new Expression[]{expression});
            }
            if (whiten.booleanValue() && !ValueUtil.isOne((Number)(explainedVarianceValue = explainedVariance.get(i)))) {
                apply = PMMLUtil.createApply((String)"/", (Expression[])new Expression[]{apply, PMMLUtil.createConstant((Number)Math.sqrt(ValueUtil.asDouble((Number)explainedVarianceValue)))});
            }
            DerivedField derivedField = encoder.createDerivedField(FieldNameUtil.create(name, i), (Expression)apply);
            result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
        }
        return result;
    }

    public Boolean getWhiten() {
        return this.getBoolean("whiten");
    }

    public List<? extends Number> getExplainedVariance() {
        return this.getNumberArray("explained_variance_");
    }

    public List<? extends Number> getMean() {
        return this.getNumberArray("mean_");
    }
}

