/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dmg.pmml.FieldName;
import org.jpmml.converter.Feature;

public class FieldNameUtil {
    private FieldNameUtil() {
    }

    public static FieldName create(String function, Object ... args) {
        return FieldNameUtil.create(function, Arrays.asList(args));
    }

    public static FieldName create(String function, List<?> args) {
        String name = FieldNameUtil.format(function, args);
        return FieldName.create((String)name);
    }

    public static FieldName create(FieldName name, int index) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        return FieldName.create((String)(name.getValue() + "[" + index + "]"));
    }

    private static String format(String function, List<?> args) {
        if (args == null || args.isEmpty()) {
            return function;
        }
        Stream<Object> argStream = args.size() <= 5 ? args.stream() : Stream.of(args.subList(0, 2).stream(), Stream.of(".."), args.subList(args.size() - 2, args.size()).stream()).flatMap(x -> x);
        return argStream.map(FieldNameUtil::toString).collect(Collectors.joining(", ", function + "(", ")"));
    }

    private static String toString(Object object) {
        if (object instanceof Feature) {
            Feature feature = (Feature)object;
            object = feature.getName();
        }
        return String.valueOf(object);
    }
}

