/*
 * Decompiled with CFR 0.152.
 */
package sklearn;

import java.util.Iterator;
import java.util.List;
import numpy.DType;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.python.ClassDictUtil;
import sklearn.HasNumberOfFeatures;
import sklearn.Step;

public class StepUtil {
    private StepUtil() {
    }

    public static void checkNumberOfFeatures(Step step, List<Feature> features) {
        HasNumberOfFeatures hasNumberOfFeatures;
        int numberOfFeatures;
        if (step instanceof HasNumberOfFeatures && (numberOfFeatures = (hasNumberOfFeatures = (HasNumberOfFeatures)((Object)step)).getNumberOfFeatures()) != -1 && numberOfFeatures != features.size()) {
            throw new IllegalArgumentException("Expected " + numberOfFeatures + " feature(s) (" + ClassDictUtil.formatClass((Object)((Object)step)) + "), got " + features.size() + " feature(s)");
        }
    }

    public static int getNumberOfFeatures(List<? extends Step> steps) {
        Iterator<? extends Step> iterator = steps.iterator();
        if (iterator.hasNext()) {
            Step step = iterator.next();
            return StepUtil.getNumberOfFeatures(step);
        }
        return -1;
    }

    public static int getNumberOfFeatures(Step step) {
        if (step instanceof HasNumberOfFeatures) {
            HasNumberOfFeatures hasNumberOfFeatures = (HasNumberOfFeatures)((Object)step);
            return hasNumberOfFeatures.getNumberOfFeatures();
        }
        return -1;
    }

    public static OpType getOpType(DataType dataType) {
        switch (dataType) {
            case STRING: {
                return OpType.CATEGORICAL;
            }
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: {
                return OpType.CONTINUOUS;
            }
            case BOOLEAN: {
                return OpType.CATEGORICAL;
            }
            case DATE: 
            case DATE_TIME: {
                return OpType.ORDINAL;
            }
        }
        throw new IllegalArgumentException();
    }

    public static OpType getOpType(Object dtype) {
        DataType dataType = StepUtil.getDataType(dtype);
        return StepUtil.getOpType(dataType);
    }

    public static DataType getDataType(Object dtype) {
        if (dtype instanceof String) {
            String stringDType = (String)dtype;
            return StepUtil.parseDataType(stringDType);
        }
        DType numpyDType = (DType)dtype;
        return numpyDType.getDataType();
    }

    public static DataType parseDataType(String dtype) {
        switch (dtype) {
            case "datetime64[D]": {
                return DataType.DATE;
            }
            case "datetime64[s]": {
                return DataType.DATE_TIME;
            }
        }
        throw new IllegalArgumentException(dtype);
    }
}

