/*
 * Decompiled with CFR 0.152.
 */
package sklearn.impute;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dmg.pmml.MissingValueTreatmentMethod;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ValueUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.HasNumberOfFeatures;
import sklearn.Transformer;
import sklearn.impute.ImputerUtil;

public class SimpleImputer
extends Transformer
implements HasNumberOfFeatures {
    public SimpleImputer(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape = this.getStatisticsShape();
        return shape[0];
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        Boolean addIndicator = this.getAddIndicator();
        Object missingValues = this.getMissingValues();
        List<?> statistics = this.getStatistics();
        String strategy = this.getStrategy();
        ClassDictUtil.checkSize((Collection[])new Collection[]{features, statistics});
        if (ValueUtil.isNaN((Object)missingValues)) {
            missingValues = null;
        }
        MissingValueTreatmentMethod missingValueTreatment = SimpleImputer.parseStrategy(strategy);
        ArrayList<Feature> indicatorFeatures = new ArrayList<Feature>();
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            Object statistic = statistics.get(i);
            if (addIndicator.booleanValue()) {
                Feature indicatorFeature = ImputerUtil.encodeIndicatorFeature(this, feature, missingValues, encoder);
                indicatorFeatures.add(indicatorFeature);
            }
            feature = ImputerUtil.encodeFeature(this, feature, addIndicator, missingValues, statistic, missingValueTreatment, encoder);
            result.add(feature);
        }
        if (addIndicator.booleanValue()) {
            result.addAll(indicatorFeatures);
        }
        return result;
    }

    public Boolean getAddIndicator() {
        return this.getOptionalBoolean("add_indicator", Boolean.FALSE);
    }

    public Object getMissingValues() {
        return this.getOptionalScalar("missing_values");
    }

    public List<?> getStatistics() {
        return this.getArray("statistics_");
    }

    public int[] getStatisticsShape() {
        return this.getArrayShape("statistics_", 1);
    }

    public String getStrategy() {
        return this.getString("strategy");
    }

    private static MissingValueTreatmentMethod parseStrategy(String strategy) {
        switch (strategy) {
            case "constant": {
                return MissingValueTreatmentMethod.AS_VALUE;
            }
            case "mean": {
                return MissingValueTreatmentMethod.AS_MEAN;
            }
            case "median": {
                return MissingValueTreatmentMethod.AS_MEDIAN;
            }
            case "most_frequent": {
                return MissingValueTreatmentMethod.AS_MODE;
            }
        }
        throw new IllegalArgumentException(strategy);
    }
}

