/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldRef;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.HasNumberOfFeatures;
import sklearn.Transformer;

public class RobustScaler
extends Transformer
implements HasNumberOfFeatures {
    public RobustScaler(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        int[] shape;
        Boolean withCentering = this.getWithCentering();
        Boolean withScaling = this.getWithScaling();
        if (withCentering.booleanValue()) {
            shape = this.getCenterShape();
        } else if (withScaling.booleanValue()) {
            shape = this.getScaleShape();
        } else {
            return -1;
        }
        return shape[0];
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<? extends Number> scale;
        Boolean withCentering = this.getWithCentering();
        Boolean withScaling = this.getWithScaling();
        List<? extends Number> center = withCentering != false ? this.getCenter() : null;
        List<? extends Number> list = scale = withScaling != false ? this.getScale() : null;
        if (center == null && scale == null) {
            return features;
        }
        ClassDictUtil.checkSize((Collection[])new Collection[]{features, center, scale});
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Double scaleValue;
            Feature feature = features.get(i);
            Double centerValue = withCentering != false ? (Number)center.get(i) : (Number)0.0;
            Number number = scaleValue = withScaling != false ? (Number)scale.get(i) : (Number)1.0;
            if (ValueUtil.isZero((Number)centerValue) && ValueUtil.isOne((Number)scaleValue)) {
                result.add(feature);
                continue;
            }
            ContinuousFeature continuousFeature = feature.toContinuousFeature();
            FieldRef expression = continuousFeature.ref();
            if (!ValueUtil.isZero((Number)centerValue)) {
                expression = PMMLUtil.createApply((String)"-", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Number)centerValue)});
            }
            if (!ValueUtil.isOne((Number)scaleValue)) {
                expression = PMMLUtil.createApply((String)"/", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Number)scaleValue)});
            }
            DerivedField derivedField = encoder.createDerivedField(this.createFieldName("RobustScaler", continuousFeature), (Expression)expression);
            result.add((Feature)new ContinuousFeature((PMMLEncoder)encoder, (Field)derivedField));
        }
        return result;
    }

    public Boolean getWithCentering() {
        return this.getBoolean("with_centering");
    }

    public Boolean getWithScaling() {
        return this.getBoolean("with_scaling");
    }

    public List<? extends Number> getCenter() {
        return this.getNumberArray("center_");
    }

    public int[] getCenterShape() {
        return this.getArrayShape("center_", 1);
    }

    public List<? extends Number> getScale() {
        return this.getNumberArray("scale_");
    }

    public int[] getScaleShape() {
        return this.getArrayShape("scale_", 1);
    }
}

