/*
 * Decompiled with CFR 0.152.
 */
package sklearn.feature_extraction.text;

import com.google.common.base.Joiner;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import numpy.DType;
import numpy.core.ScalarUtil;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.dmg.pmml.ParameterField;
import org.dmg.pmml.TextIndex;
import org.dmg.pmml.TextIndexNormalization;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.ObjectFeature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.StringFeature;
import org.jpmml.converter.ValueUtil;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.HasNumberOfFeatures;
import sklearn.Transformer;
import sklearn2pmml.feature_extraction.text.Splitter;

public class CountVectorizer
extends Transformer
implements HasNumberOfFeatures {
    private static final Joiner JOINER = Joiner.on((String)"|");

    public CountVectorizer(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        return 1;
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public DataType getDataType() {
        return DataType.STRING;
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        DataType dataType;
        Boolean lowercase = this.getLowercase();
        Map<String, ?> vocabulary = this.getVocabulary();
        ClassDictUtil.checkSize((int)1, (Collection[])new Collection[]{features});
        Feature feature = features.get(0);
        HashBiMap termIndexMap = HashBiMap.create((int)vocabulary.size());
        Set<Map.Entry<String, ?>> entries = vocabulary.entrySet();
        for (Map.Entry entry : entries) {
            termIndexMap.put(entry.getKey(), (Object)ValueUtil.asInteger((Number)((Number)ScalarUtil.decode(entry.getValue()))));
        }
        BiMap indexTermMap = termIndexMap.inverse();
        DType dType = this.getDType();
        DataType dataType2 = dataType = dType != null ? dType.getDataType() : DataType.DOUBLE;
        if (lowercase.booleanValue()) {
            Apply apply = PMMLUtil.createApply((String)"lowercase", (Expression[])new Expression[]{feature.ref()});
            DerivedField derivedField = encoder.ensureDerivedField(FieldNameUtil.create((String)"lowercase", (Object[])new Object[]{feature}), OpType.CATEGORICAL, DataType.STRING, () -> apply);
            feature = new StringFeature((PMMLEncoder)encoder, (Field)derivedField);
        }
        DefineFunction defineFunction = this.encodeDefineFunction(feature);
        encoder.addDefineFunction(defineFunction);
        ArrayList<Feature> result = new ArrayList<Feature>();
        int max = indexTermMap.size();
        for (int i = 0; i < max; ++i) {
            String term = (String)indexTermMap.get((Object)i);
            final Apply apply = this.encodeApply(defineFunction.getName(), feature, i, term);
            ObjectFeature termFeature = new ObjectFeature((PMMLEncoder)encoder, FieldNameUtil.create((String)this.functionName(), (Object[])new Object[]{feature, term}), dataType){

                public ContinuousFeature toContinuousFeature() {
                    return this.toContinuousFeature(this.getName(), this.getDataType(), () -> apply);
                }
            };
            result.add((Feature)termFeature);
        }
        return result;
    }

    public DefineFunction encodeDefineFunction(Feature feature) {
        String analyzer = this.getAnalyzer();
        List<String> stopWords = this.getStopWords();
        Object[] nGramRange = this.getNGramRange();
        Boolean binary = this.getBinary();
        Object preprocessor = this.getPreprocessor();
        String stripAccents = this.getStripAccents();
        Splitter tokenizer = this.getTokenizer();
        switch (analyzer) {
            case "word": {
                break;
            }
            default: {
                throw new IllegalArgumentException(analyzer);
            }
        }
        if (preprocessor != null) {
            throw new IllegalArgumentException();
        }
        if (stripAccents != null) {
            throw new IllegalArgumentException(stripAccents);
        }
        ParameterField documentField = new ParameterField(FieldName.create((String)"document"));
        ParameterField termField = new ParameterField(FieldName.create((String)"term"));
        TextIndex textIndex = new TextIndex(documentField.getName(), (Expression)new FieldRef(termField.getName())).setTokenize(Boolean.TRUE).setWordSeparatorCharacterRE(tokenizer.getSeparatorRE()).setLocalTermWeights((TextIndex.LocalTermWeights)(binary != false ? TextIndex.LocalTermWeights.BINARY : null));
        if (stopWords != null && stopWords.size() > 0 && !Arrays.equals(nGramRange, (Object[])new Integer[]{1, 1})) {
            LinkedHashMap<String, List<String>> data = new LinkedHashMap<String, List<String>>();
            data.put("string", Collections.singletonList("(^|\\s+)\\p{Punct}*(" + JOINER.join(stopWords) + ")\\p{Punct}*(\\s+|$)"));
            data.put("stem", Collections.singletonList(" "));
            data.put("regex", Collections.singletonList("true"));
            TextIndexNormalization textIndexNormalization = new TextIndexNormalization(null, PMMLUtil.createInlineTable(data)).setRecursive(Boolean.TRUE);
            textIndex.addTextIndexNormalizations(new TextIndexNormalization[]{textIndexNormalization});
        }
        FieldName name = this.createFieldName(this.functionName(), feature);
        DefineFunction defineFunction = new DefineFunction(name.getValue(), OpType.CONTINUOUS, DataType.DOUBLE, null, (Expression)textIndex).addParameterFields(new ParameterField[]{documentField, termField});
        return defineFunction;
    }

    public Apply encodeApply(String function, Feature feature, int index, String term) {
        Constant constant = PMMLUtil.createConstant((Object)term, (DataType)DataType.STRING);
        return PMMLUtil.createApply((String)function, (Expression[])new Expression[]{feature.ref(), constant});
    }

    public String functionName() {
        return "tf";
    }

    public String getAnalyzer() {
        return this.getString("analyzer");
    }

    public Boolean getBinary() {
        return this.getBoolean("binary");
    }

    public DType getDType() {
        return (DType)this.getDType(false);
    }

    public Boolean getLowercase() {
        return this.getBoolean("lowercase");
    }

    public Object[] getNGramRange() {
        return this.getTuple("ngram_range");
    }

    public Object getPreprocessor() {
        return this.getOptionalObject("preprocessor");
    }

    public List<String> getStopWords() {
        Object stopWords = this.getOptionalObject("stop_words");
        if (stopWords instanceof String) {
            return CountVectorizer.loadStopWords((String)stopWords);
        }
        return (List)stopWords;
    }

    public String getStripAccents() {
        return this.getOptionalString("strip_accents");
    }

    public Splitter getTokenizer() {
        return (Splitter)((Object)this.get("tokenizer", Splitter.class));
    }

    public Map<String, ?> getVocabulary() {
        return this.getDict("vocabulary_");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> loadStopWords(String stopWords) {
        InputStream is = CountVectorizer.class.getResourceAsStream("/stop_words/" + stopWords + ".txt");
        if (is == null) {
            throw new IllegalArgumentException(stopWords);
        }
        try (InputStreamReader reader = new InputStreamReader(is, "UTF-8");){
            List list = CharStreams.readLines((Readable)reader);
            return list;
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(stopWords, ioe);
        }
    }
}

