/*
 * Decompiled with CFR 0.152.
 */
package sklearn.preprocessing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.converter.BaseNFeature;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ObjectFeature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.WildcardFeature;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.HasArray;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn.MultiTransformer;
import sklearn.preprocessing.EncoderUtil;

public class MultiOneHotEncoder
extends MultiTransformer {
    public MultiOneHotEncoder(String module, String name) {
        super(module, name);
    }

    @Override
    public OpType getOpType() {
        return OpType.CATEGORICAL;
    }

    @Override
    public DataType getDataType() {
        return super.getDataType();
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        List<List<?>> categories = this.getCategories();
        ClassDictUtil.checkSize((Collection[])new Collection[]{categories, features});
        Object drop = this.getDrop();
        List<Integer> dropIdx = drop != null ? this.getDropIdx() : null;
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            CategoricalFeature categoricalFeature;
            Feature feature = features.get(i);
            ArrayList featureCategories = categories.get(i);
            if (feature instanceof BaseNFeature) {
                BaseNFeature baseFeature = (BaseNFeature)feature;
                ContinuousFeature continuousFeature = baseFeature.toContinuousFeature();
                encoder.toCategorical(continuousFeature.getName(), null);
                feature = continuousFeature;
            } else if (feature instanceof CategoricalFeature) {
                categoricalFeature = (CategoricalFeature)feature;
                ClassDictUtil.checkSize((Collection[])new Collection[]{featureCategories, categoricalFeature.getValues()});
                featureCategories = categoricalFeature.getValues();
            } else if (feature instanceof ObjectFeature) {
                categoricalFeature = (ObjectFeature)feature;
            } else if (feature instanceof WildcardFeature) {
                WildcardFeature wildcardFeature = (WildcardFeature)feature;
                feature = wildcardFeature.toCategoricalFeature(featureCategories);
            } else {
                throw new IllegalArgumentException();
            }
            if (dropIdx != null) {
                int index = dropIdx.get(i);
                featureCategories = new ArrayList(featureCategories);
                featureCategories.remove(index);
            }
            for (int j = 0; j < featureCategories.size(); ++j) {
                Object featureCategory = featureCategories.get(j);
                result.add((Feature)new BinaryFeature((PMMLEncoder)encoder, feature, featureCategory));
            }
        }
        return result;
    }

    public List<List<?>> getCategories() {
        return EncoderUtil.transformCategories(this.getList("categories_", HasArray.class));
    }

    public Object getDrop() {
        return this.getOptionalObject("drop");
    }

    public List<Integer> getDropIdx() {
        return this.getIntegerArray("drop_idx_");
    }
}

