/*
 * Decompiled with CFR 0.152.
 */
package sklearn.ensemble.gradient_boosting;

import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.regression.RegressionModel;
import org.jpmml.converter.CMatrixUtil;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.FieldNameUtil;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.SchemaUtil;
import org.jpmml.converter.Transformation;
import org.jpmml.converter.mining.MiningModelUtil;
import sklearn.Classifier;
import sklearn.Estimator;
import sklearn.HasEstimatorEnsemble;
import sklearn.HasPriorProbability;
import sklearn.SkLearnUtil;
import sklearn.ensemble.gradient_boosting.GradientBoostingUtil;
import sklearn.ensemble.gradient_boosting.LossFunction;
import sklearn.tree.HasTreeOptions;
import sklearn.tree.TreeRegressor;
import sklearn2pmml.EstimatorProxy;

public class GradientBoostingClassifier
extends Classifier
implements HasEstimatorEnsemble<TreeRegressor>,
HasTreeOptions {
    public GradientBoostingClassifier(String module, String name) {
        super(module, name);
    }

    @Override
    public int getNumberOfFeatures() {
        if (this.containsKey("n_features")) {
            return this.getInteger("n_features");
        }
        return super.getNumberOfFeatures();
    }

    @Override
    public DataType getDataType() {
        return DataType.FLOAT;
    }

    public MiningModel encodeModel(Schema schema) {
        String sklearnVersion = this.getSkLearnVersion();
        LossFunction loss = this.getLoss();
        int numberOfClasses = loss.getK();
        HasPriorProbability init = this.getInit();
        Number learningRate = this.getLearningRate();
        IntFunction<Number> initialPredictions = init::getPriorProbability;
        if (sklearnVersion != null && SkLearnUtil.compareVersion(sklearnVersion, "0.21") >= 0) {
            List<? extends Number> computedInitialPredictions = loss.computeInitialPredictions(init);
            initialPredictions = computedInitialPredictions::get;
        }
        Schema segmentSchema = schema.toAnonymousRegressorSchema(DataType.DOUBLE);
        CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
        if (numberOfClasses == 1) {
            SchemaUtil.checkSize((int)2, (CategoricalLabel)categoricalLabel);
            MiningModel miningModel = GradientBoostingUtil.encodeGradientBoosting(this, initialPredictions.apply(1), learningRate, segmentSchema).setOutput(ModelUtil.createPredictedOutput((FieldName)FieldNameUtil.create((String)"decisionFunction", (Object[])new Object[]{categoricalLabel.getValue(1)}), (OpType)OpType.CONTINUOUS, (DataType)DataType.DOUBLE, (Transformation[])new Transformation[]{loss.createTransformation()}));
            return MiningModelUtil.createBinaryLogisticClassification((Model)miningModel, (double)1.0, (double)0.0, (RegressionModel.NormalizationMethod)RegressionModel.NormalizationMethod.NONE, (boolean)true, (Schema)schema);
        }
        if (numberOfClasses >= 3) {
            SchemaUtil.checkSize((int)numberOfClasses, (CategoricalLabel)categoricalLabel);
            List<? extends TreeRegressor> estimators = this.getEstimators();
            ArrayList<MiningModel> miningModels = new ArrayList<MiningModel>();
            int columns = categoricalLabel.size();
            int rows = estimators.size() / columns;
            for (int i = 0; i < columns; ++i) {
                final List columnEstimators = CMatrixUtil.getColumn(estimators, (int)rows, (int)columns, (int)i);
                GradientBoostingClassifierProxy estimatorProxy = new GradientBoostingClassifierProxy(){

                    @Override
                    public List<? extends TreeRegressor> getEstimators() {
                        return columnEstimators;
                    }
                };
                MiningModel miningModel = GradientBoostingUtil.encodeGradientBoosting(estimatorProxy, initialPredictions.apply(i), learningRate, segmentSchema).setOutput(ModelUtil.createPredictedOutput((FieldName)FieldNameUtil.create((String)"decisionFunction", (Object[])new Object[]{categoricalLabel.getValue(i)}), (OpType)OpType.CONTINUOUS, (DataType)DataType.DOUBLE, (Transformation[])new Transformation[]{loss.createTransformation()}));
                miningModels.add(miningModel);
            }
            return MiningModelUtil.createClassification(miningModels, (RegressionModel.NormalizationMethod)RegressionModel.NormalizationMethod.SIMPLEMAX, (boolean)true, (Schema)schema);
        }
        throw new IllegalArgumentException();
    }

    public LossFunction getLoss() {
        return (LossFunction)((Object)this.get("loss_", LossFunction.class));
    }

    public HasPriorProbability getInit() {
        return (HasPriorProbability)this.get("init_", HasPriorProbability.class);
    }

    public Number getLearningRate() {
        return this.getNumber("learning_rate");
    }

    @Override
    public List<? extends TreeRegressor> getEstimators() {
        return this.getArray("estimators_", TreeRegressor.class);
    }

    private abstract class GradientBoostingClassifierProxy
    extends EstimatorProxy
    implements HasEstimatorEnsemble<TreeRegressor>,
    HasTreeOptions {
        private GradientBoostingClassifierProxy() {
        }

        @Override
        public Estimator getEstimator() {
            return GradientBoostingClassifier.this;
        }
    }
}

