/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.spark.ml.feature.StringIndexerModel;
import org.dmg.pmml.DataField;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ListFeature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.FeatureMapper;

public class StringIndexerModelConverter
extends FeatureConverter<StringIndexerModel> {
    public StringIndexerModelConverter(StringIndexerModel transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(FeatureMapper featureMapper) {
        StringIndexerModel transformer = (StringIndexerModel)this.getTransformer();
        Feature inputFeature = featureMapper.getOnlyFeature(transformer.getInputCol());
        List<String> categories = Arrays.asList(transformer.labels());
        DataField dataField = featureMapper.getDataField(inputFeature.getName());
        if (dataField != null) {
            dataField.setOpType(OpType.CATEGORICAL);
            List values = dataField.getValues();
            if (values.size() > 0) {
                throw new IllegalArgumentException();
            }
            values.addAll(PMMLUtil.createValues(categories));
        }
        ListFeature feature = new ListFeature((TypeDefinitionField)dataField, categories);
        return Collections.singletonList(feature);
    }
}

