/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.ml.feature.MinMaxScalerModel;
import org.apache.spark.mllib.linalg.Vector;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.FeatureMapper;

public class MinMaxScalerModelConverter
extends FeatureConverter<MinMaxScalerModel> {
    public MinMaxScalerModelConverter(MinMaxScalerModel transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(FeatureMapper featureMapper) {
        MinMaxScalerModel transformer = (MinMaxScalerModel)this.getTransformer();
        double rescaleFactor = transformer.getMax() - transformer.getMin();
        double rescaleConstant = transformer.getMin();
        List<Feature> inputFeatures = featureMapper.getFeatures(transformer.getInputCol());
        Vector originalMax = transformer.originalMax();
        if (originalMax.size() != inputFeatures.size()) {
            throw new IllegalArgumentException();
        }
        Vector originalMin = transformer.originalMin();
        if (originalMin.size() != inputFeatures.size()) {
            throw new IllegalArgumentException();
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < inputFeatures.size(); ++i) {
            ContinuousFeature inputFeature = (ContinuousFeature)inputFeatures.get(i);
            double max = originalMax.apply(i);
            double min = originalMin.apply(i);
            Apply expression = PMMLUtil.createApply((String)"/", (Expression[])new Expression[]{PMMLUtil.createApply((String)"-", (Expression[])new Expression[]{inputFeature.ref(), PMMLUtil.createConstant((Object)min)}), PMMLUtil.createConstant((Object)(max - min))});
            if (!ValueUtil.isOne((Number)rescaleFactor)) {
                expression = PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Object)rescaleFactor)});
            }
            if (!ValueUtil.isZero((Number)rescaleConstant)) {
                expression = PMMLUtil.createApply((String)"+", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Object)rescaleConstant)});
            }
            DerivedField derivedField = featureMapper.createDerivedField(FieldName.create((String)(transformer.getOutputCol() + "[" + String.valueOf(i) + "]")), OpType.CONTINUOUS, DataType.DOUBLE, (Expression)expression);
            ContinuousFeature feature = new ContinuousFeature((TypeDefinitionField)derivedField);
            result.add((Feature)feature);
        }
        return result;
    }
}

