/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.ml.feature.PCAModel;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.FeatureMapper;

public class PCAModelConverter
extends FeatureConverter<PCAModel> {
    public PCAModelConverter(PCAModel transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(FeatureMapper featureMapper) {
        PCAModel transformer = (PCAModel)this.getTransformer();
        List<Feature> inputFeatures = featureMapper.getFeatures(transformer.getInputCol());
        DenseMatrix pc = transformer.pc();
        if (pc.numRows() != inputFeatures.size()) {
            throw new IllegalArgumentException();
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < transformer.getK(); ++i) {
            Apply apply = new Apply("sum");
            for (int j = 0; j < inputFeatures.size(); ++j) {
                ContinuousFeature inputFeature = (ContinuousFeature)inputFeatures.get(j);
                FieldRef expression = inputFeature.ref();
                double coefficient = pc.apply(j, i);
                if (!ValueUtil.isOne((Number)coefficient)) {
                    expression = PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Object)coefficient)});
                }
                apply.addExpressions(new Expression[]{expression});
            }
            DerivedField derivedField = featureMapper.createDerivedField(FieldName.create((String)(transformer.getOutputCol() + "[" + String.valueOf(i) + "]")), OpType.CONTINUOUS, DataType.DOUBLE, (Expression)apply);
            ContinuousFeature feature = new ContinuousFeature((TypeDefinitionField)derivedField);
            result.add((Feature)feature);
        }
        return result;
    }
}

