/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.ml.feature.StandardScalerModel;
import org.apache.spark.mllib.linalg.Vector;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.FeatureMapper;

public class StandardScalerModelConverter
extends FeatureConverter<StandardScalerModel> {
    public StandardScalerModelConverter(StandardScalerModel transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(FeatureMapper featureMapper) {
        StandardScalerModel transformer = (StandardScalerModel)this.getTransformer();
        List<Feature> inputFeatures = featureMapper.getFeatures(transformer.getInputCol());
        Vector mean = transformer.mean();
        if (transformer.getWithMean() && mean.size() != inputFeatures.size()) {
            throw new IllegalArgumentException();
        }
        Vector std = transformer.std();
        if (transformer.getWithStd() && std.size() != inputFeatures.size()) {
            throw new IllegalArgumentException();
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < inputFeatures.size(); ++i) {
            double stdValue;
            double meanValue;
            ContinuousFeature inputFeature = (ContinuousFeature)inputFeatures.get(i);
            FieldRef expression = inputFeature.ref();
            if (transformer.getWithMean() && !ValueUtil.isZero((Number)(meanValue = mean.apply(i)))) {
                expression = PMMLUtil.createApply((String)"-", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Object)meanValue)});
            }
            if (transformer.getWithStd() && !ValueUtil.isOne((Number)(stdValue = std.apply(i)))) {
                expression = PMMLUtil.createApply((String)"*", (Expression[])new Expression[]{expression, PMMLUtil.createConstant((Object)(1.0 / stdValue))});
            }
            DerivedField derivedField = featureMapper.createDerivedField(FieldName.create((String)(transformer.getOutputCol() + "[" + String.valueOf(i) + "]")), OpType.CONTINUOUS, DataType.DOUBLE, (Expression)expression);
            ContinuousFeature feature = new ContinuousFeature((TypeDefinitionField)derivedField);
            result.add((Feature)feature);
        }
        return result;
    }
}

