/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.ml.feature.OneHotEncoder;
import org.apache.spark.ml.param.Param;
import org.dmg.pmml.DataType;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ListFeature;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.FeatureMapper;
import scala.Option;

public class OneHotEncoderConverter
extends FeatureConverter<OneHotEncoder> {
    public OneHotEncoderConverter(OneHotEncoder transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(FeatureMapper featureMapper) {
        OneHotEncoder transformer = (OneHotEncoder)this.getTransformer();
        ListFeature inputFeature = (ListFeature)featureMapper.getOnlyFeature(transformer.getInputCol());
        List values = inputFeature.getValues();
        boolean dropLast = true;
        Option dropLastOption = transformer.get((Param)transformer.dropLast());
        if (dropLastOption.isDefined()) {
            dropLast = (Boolean)dropLastOption.get();
        }
        if (dropLast) {
            values = values.subList(0, values.size() - 1);
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (String value : values) {
            BinaryFeature feature = new BinaryFeature(inputFeature.getName(), DataType.STRING, value);
            result.add((Feature)feature);
        }
        return result;
    }
}

