/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.model;

import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.spark.ml.clustering.KMeansModel;
import org.apache.spark.mllib.linalg.Vector;
import org.dmg.pmml.Array;
import org.dmg.pmml.Cluster;
import org.dmg.pmml.ClusteringModel;
import org.dmg.pmml.CompareFunctionType;
import org.dmg.pmml.ComparisonMeasure;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.Measure;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.Output;
import org.dmg.pmml.SquaredEuclidean;
import org.jpmml.converter.ClusteringModelUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.Schema;
import org.jpmml.sparkml.FeatureMapper;
import org.jpmml.sparkml.ModelConverter;

public class KMeansModelConverter
extends ModelConverter<KMeansModel> {
    public KMeansModelConverter(KMeansModel model) {
        super(model);
    }

    @Override
    public List<Feature> encodeFeatures(FeatureMapper featureMapper) {
        KMeansModel model = (KMeansModel)this.getTransformer();
        return Collections.emptyList();
    }

    @Override
    public MiningFunctionType getMiningFunction() {
        return MiningFunctionType.CLUSTERING;
    }

    public ClusteringModel encodeModel(Schema schema) {
        KMeansModel model = (KMeansModel)this.getTransformer();
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        Vector[] clusterCenters = model.clusterCenters();
        for (int i = 0; i < clusterCenters.length; ++i) {
            Vector clusterCenter = clusterCenters[i];
            Array array = PMMLUtil.createRealArray((List)Doubles.asList((double[])clusterCenter.toArray()));
            Cluster cluster = new Cluster().setId(String.valueOf(i)).setArray(array);
            clusters.add(cluster);
        }
        List features = schema.getFeatures();
        List clusteringFields = ClusteringModelUtil.createClusteringFields((List)features);
        ComparisonMeasure comparisonMeasure = new ComparisonMeasure(ComparisonMeasure.Kind.DISTANCE).setCompareFunction(CompareFunctionType.ABS_DIFF).setMeasure((Measure)new SquaredEuclidean());
        Output output = ClusteringModelUtil.createOutput((FieldName)FieldName.create((String)"cluster"), Collections.emptyList());
        ClusteringModel clusteringModel = new ClusteringModel(MiningFunctionType.CLUSTERING, ClusteringModel.ModelClass.CENTER_BASED, clusters.size(), ModelUtil.createMiningSchema(null, (List)schema.getActiveFields()), comparisonMeasure, clusteringFields, clusters).setOutput(output);
        return clusteringModel;
    }
}

