/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.model;

import java.util.List;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.dmg.pmml.MiningFunctionType;
import org.dmg.pmml.RegressionModel;
import org.dmg.pmml.RegressionNormalizationMethodType;
import org.dmg.pmml.RegressionTable;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.sparkml.ClassificationModelConverter;
import org.jpmml.sparkml.model.RegressionModelUtil;

public class LogisticRegressionModelConverter
extends ClassificationModelConverter<LogisticRegressionModel> {
    public LogisticRegressionModelConverter(LogisticRegressionModel model) {
        super(model);
    }

    public RegressionModel encodeModel(Schema schema) {
        LogisticRegressionModel model = (LogisticRegressionModel)this.getTransformer();
        List targetCategories = schema.getTargetCategories();
        if (targetCategories.size() != 2) {
            throw new IllegalArgumentException();
        }
        RegressionTable activeRegressionTable = RegressionModelUtil.encodeRegressionTable(model.intercept(), model.coefficients(), schema).setTargetCategory((String)targetCategories.get(1));
        RegressionTable passiveRegressionTable = new RegressionTable(0.0).setTargetCategory((String)targetCategories.get(0));
        RegressionModel regressionModel = new RegressionModel(MiningFunctionType.CLASSIFICATION, ModelUtil.createMiningSchema((Schema)schema), null).setNormalizationMethod(RegressionNormalizationMethodType.SOFTMAX).addRegressionTables(new RegressionTable[]{activeRegressionTable, passiveRegressionTable}).setOutput(ModelUtil.createProbabilityOutput((Schema)schema));
        return regressionModel;
    }
}

