/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.tree.CategoricalSplit;
import org.apache.spark.ml.tree.ContinuousSplit;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.InternalNode;
import org.apache.spark.ml.tree.LeafNode;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.Split;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.mllib.tree.impurity.ImpurityCalculator;
import org.dmg.pmml.Array;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.ScoreDistribution;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.Target;
import org.dmg.pmml.Targets;
import org.dmg.pmml.True;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ListFeature;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sparkml.BooleanFeature;

public class TreeModelUtil {
    private static final double[] TRUE = new double[]{1.0};
    private static final double[] FALSE = new double[]{0.0};

    private TreeModelUtil() {
    }

    public static TreeModel encodeDecisionTree(DecisionTreeModel model, Schema schema) {
        Node node = model.rootNode();
        if (model instanceof DecisionTreeRegressionModel) {
            return TreeModelUtil.encodeTreeModel(MiningFunction.REGRESSION, node, schema);
        }
        if (model instanceof DecisionTreeClassificationModel) {
            return TreeModelUtil.encodeTreeModel(MiningFunction.CLASSIFICATION, node, schema);
        }
        throw new IllegalArgumentException();
    }

    public static List<TreeModel> encodeDecisionTreeEnsemble(TreeEnsembleModel<?> model, Schema schema) {
        return TreeModelUtil.encodeDecisionTreeEnsemble(model, null, schema);
    }

    public static List<TreeModel> encodeDecisionTreeEnsemble(TreeEnsembleModel<?> model, double[] weights, Schema schema) {
        Schema segmentSchema = schema.toAnonymousSchema();
        ArrayList<TreeModel> treeModels = new ArrayList<TreeModel>();
        DecisionTreeModel[] trees = model.trees();
        for (int i = 0; i < trees.length; ++i) {
            DecisionTreeModel tree = trees[i];
            Double weight = weights != null ? Double.valueOf(weights[i]) : null;
            TreeModel treeModel = TreeModelUtil.encodeDecisionTree(tree, segmentSchema);
            if (weight != null && !ValueUtil.isOne((Number)weight)) {
                Targets targets = new Targets().addTargets(new Target[]{ModelUtil.createRescaleTarget((FieldName)segmentSchema.getTargetField(), (Double)weight, null)});
                treeModel.setTargets(targets);
            }
            treeModels.add(treeModel);
        }
        return treeModels;
    }

    public static TreeModel encodeTreeModel(MiningFunction miningFunction, Node node, Schema schema) {
        org.dmg.pmml.tree.Node root = TreeModelUtil.encodeNode(miningFunction, node, schema).setPredicate((Predicate)new True());
        TreeModel treeModel = new TreeModel(miningFunction, ModelUtil.createMiningSchema((Schema)schema), root).setSplitCharacteristic(TreeModel.SplitCharacteristic.BINARY_SPLIT);
        return treeModel;
    }

    public static org.dmg.pmml.tree.Node encodeNode(MiningFunction miningFunction, Node node, Schema schema) {
        if (node instanceof InternalNode) {
            return TreeModelUtil.encodeInternalNode(miningFunction, (InternalNode)node, schema);
        }
        if (node instanceof LeafNode) {
            return TreeModelUtil.encodeLeafNode(miningFunction, (LeafNode)node, schema);
        }
        throw new IllegalArgumentException();
    }

    private static org.dmg.pmml.tree.Node encodeInternalNode(MiningFunction miningFunction, InternalNode internalNode, Schema schema) {
        org.dmg.pmml.tree.Node result = TreeModelUtil.createNode(miningFunction, (Node)internalNode, schema);
        Predicate[] predicates = TreeModelUtil.encodeSplit(internalNode.split(), schema);
        org.dmg.pmml.tree.Node leftChild = TreeModelUtil.encodeNode(miningFunction, internalNode.leftChild(), schema).setPredicate(predicates[0]);
        org.dmg.pmml.tree.Node rightChild = TreeModelUtil.encodeNode(miningFunction, internalNode.rightChild(), schema).setPredicate(predicates[1]);
        result.addNodes(new org.dmg.pmml.tree.Node[]{leftChild, rightChild});
        return result;
    }

    private static org.dmg.pmml.tree.Node encodeLeafNode(MiningFunction miningFunction, LeafNode leafNode, Schema schema) {
        org.dmg.pmml.tree.Node result = TreeModelUtil.createNode(miningFunction, (Node)leafNode, schema);
        return result;
    }

    private static org.dmg.pmml.tree.Node createNode(MiningFunction miningFunction, Node node, Schema schema) {
        org.dmg.pmml.tree.Node result = new org.dmg.pmml.tree.Node();
        switch (miningFunction) {
            case REGRESSION: {
                String score = ValueUtil.formatValue((Number)node.prediction());
                result.setScore(score);
                break;
            }
            case CLASSIFICATION: {
                List targetCategories = schema.getTargetCategories();
                if (targetCategories == null) {
                    throw new IllegalArgumentException();
                }
                int index = ValueUtil.asInt((Number)node.prediction());
                result.setScore((String)targetCategories.get(index));
                ImpurityCalculator impurityCalculator = node.impurityStats();
                result.setRecordCount(Double.valueOf(impurityCalculator.count()));
                double[] stats = impurityCalculator.stats();
                for (int i = 0; i < stats.length; ++i) {
                    if (stats[i] == 0.0) continue;
                    ScoreDistribution scoreDistribution = new ScoreDistribution((String)targetCategories.get(i), stats[i]);
                    result.addScoreDistributions(new ScoreDistribution[]{scoreDistribution});
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return result;
    }

    private static Predicate[] encodeSplit(Split split, Schema schema) {
        if (split instanceof ContinuousSplit) {
            return TreeModelUtil.encodeContinuousSplit((ContinuousSplit)split, schema);
        }
        if (split instanceof CategoricalSplit) {
            return TreeModelUtil.encodeCategoricalSplit((CategoricalSplit)split, schema);
        }
        throw new IllegalArgumentException();
    }

    private static Predicate[] encodeContinuousSplit(ContinuousSplit continuousSplit, Schema schema) {
        ContinuousFeature feature = (ContinuousFeature)schema.getFeature(continuousSplit.featureIndex());
        double threshold = continuousSplit.threshold();
        if (feature instanceof BooleanFeature) {
            BooleanFeature booleanFeature = (BooleanFeature)feature;
            if (threshold != 0.0) {
                throw new IllegalArgumentException();
            }
            SimplePredicate leftPredicate = new SimplePredicate(feature.getName(), SimplePredicate.Operator.EQUAL).setValue(booleanFeature.getValue(0));
            SimplePredicate rightPredicate = new SimplePredicate(feature.getName(), SimplePredicate.Operator.EQUAL).setValue(booleanFeature.getValue(1));
            return new Predicate[]{leftPredicate, rightPredicate};
        }
        String value = ValueUtil.formatValue((Number)threshold);
        SimplePredicate leftPredicate = new SimplePredicate(feature.getName(), SimplePredicate.Operator.LESS_OR_EQUAL).setValue(value);
        SimplePredicate rightPredicate = new SimplePredicate(feature.getName(), SimplePredicate.Operator.GREATER_THAN).setValue(value);
        return new Predicate[]{leftPredicate, rightPredicate};
    }

    private static Predicate[] encodeCategoricalSplit(CategoricalSplit categoricalSplit, Schema schema) {
        Feature feature = schema.getFeature(categoricalSplit.featureIndex());
        double[] leftCategories = categoricalSplit.leftCategories();
        double[] rightCategories = categoricalSplit.rightCategories();
        if (feature instanceof ListFeature) {
            ListFeature listFeature = (ListFeature)feature;
            List values = listFeature.getValues();
            if (values.size() != leftCategories.length + rightCategories.length) {
                throw new IllegalArgumentException();
            }
            Predicate leftPredicate = TreeModelUtil.createCategoricalPredicate(listFeature, leftCategories);
            Predicate rightPredicate = TreeModelUtil.createCategoricalPredicate(listFeature, rightCategories);
            return new Predicate[]{leftPredicate, rightPredicate};
        }
        if (feature instanceof BinaryFeature) {
            SimplePredicate.Operator rightOperator;
            SimplePredicate.Operator leftOperator;
            BinaryFeature binaryFeature = (BinaryFeature)feature;
            if (Arrays.equals(TRUE, leftCategories) && Arrays.equals(FALSE, rightCategories)) {
                leftOperator = SimplePredicate.Operator.EQUAL;
                rightOperator = SimplePredicate.Operator.NOT_EQUAL;
            } else if (Arrays.equals(FALSE, leftCategories) && Arrays.equals(TRUE, rightCategories)) {
                leftOperator = SimplePredicate.Operator.NOT_EQUAL;
                rightOperator = SimplePredicate.Operator.EQUAL;
            } else {
                throw new IllegalArgumentException();
            }
            String value = ValueUtil.formatValue((Object)binaryFeature.getValue());
            SimplePredicate leftPredicate = new SimplePredicate(binaryFeature.getName(), leftOperator).setValue(value);
            SimplePredicate rightPredicate = new SimplePredicate(binaryFeature.getName(), rightOperator).setValue(value);
            return new Predicate[]{leftPredicate, rightPredicate};
        }
        throw new IllegalArgumentException();
    }

    private static Predicate createCategoricalPredicate(ListFeature listFeature, double[] categories) {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < categories.length; ++i) {
            int index = ValueUtil.asInt((Number)categories[i]);
            String value = listFeature.getValue(index);
            values.add(value);
        }
        if (values.size() == 1) {
            String value = (String)values.get(0);
            SimplePredicate simplePredicate = new SimplePredicate().setField(listFeature.getName()).setOperator(SimplePredicate.Operator.EQUAL).setValue(value);
            return simplePredicate;
        }
        Array array = new Array(Array.Type.INT, ValueUtil.formatArrayValue(values));
        SimpleSetPredicate simpleSetPredicate = new SimpleSetPredicate().setField(listFeature.getName()).setBooleanOperator(SimpleSetPredicate.BooleanOperator.IS_IN).setArray(array);
        return simpleSetPredicate;
    }
}

