/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.ml.feature.MaxAbsScalerModel;
import org.apache.spark.ml.linalg.Vector;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.SparkMLEncoder;

public class MaxAbsScalerModelConverter
extends FeatureConverter<MaxAbsScalerModel> {
    public MaxAbsScalerModelConverter(MaxAbsScalerModel transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        MaxAbsScalerModel transformer = (MaxAbsScalerModel)this.getTransformer();
        List<Feature> features = encoder.getFeatures(transformer.getInputCol());
        Vector maxAbs = transformer.maxAbs();
        if (maxAbs.size() != features.size()) {
            throw new IllegalArgumentException();
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            double maxAbsUnzero = maxAbs.apply(i);
            if (maxAbsUnzero == 0.0) {
                maxAbsUnzero = 1.0;
            }
            if (!ValueUtil.isOne((Number)maxAbsUnzero)) {
                ContinuousFeature continuousFeature = feature.toContinuousFeature();
                Apply expression = PMMLUtil.createApply((String)"/", (Expression[])new Expression[]{continuousFeature.ref(), PMMLUtil.createConstant((Object)maxAbsUnzero)});
                DerivedField derivedField = encoder.createDerivedField(MaxAbsScalerModelConverter.formatName(transformer, i), OpType.CONTINUOUS, DataType.DOUBLE, (Expression)expression);
                feature = new ContinuousFeature((PMMLEncoder)encoder, (TypeDefinitionField)derivedField);
            }
            result.add(feature);
        }
        return result;
    }
}

