/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import java.util.List;
import java.util.ListIterator;
import org.jpmml.converter.Feature;
import org.jpmml.sparkml.ScaledFeature;

public class ScaledFeatureUtil {
    private ScaledFeatureUtil() {
    }

    public static void simplify(List<Feature> features, List<Double> coefficients) {
        if (features.size() != coefficients.size()) {
            throw new IllegalArgumentException();
        }
        ListIterator<Feature> featureIt = features.listIterator();
        ListIterator<Double> coefficientIt = coefficients.listIterator();
        while (featureIt.hasNext()) {
            Feature feature = featureIt.next();
            Double coefficient = coefficientIt.next();
            if (!(feature instanceof ScaledFeature)) continue;
            ScaledFeature scaledFeature = (ScaledFeature)feature;
            featureIt.set(scaledFeature.getFeature());
            coefficientIt.set(coefficient * scaledFeature.getFactor());
        }
    }
}

