/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.model;

import java.util.List;
import org.apache.spark.ml.classification.GBTClassificationModel;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.mining.Segmentation;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.mining.MiningModelUtil;
import org.jpmml.sparkml.ClassificationModelConverter;
import org.jpmml.sparkml.model.TreeModelUtil;

public class GBTClassificationModelConverter
extends ClassificationModelConverter<GBTClassificationModel> {
    public GBTClassificationModelConverter(GBTClassificationModel model) {
        super(model);
    }

    public MiningModel encodeModel(Schema schema) {
        GBTClassificationModel model = (GBTClassificationModel)this.getTransformer();
        Schema segmentSchema = schema.toAnonymousSchema();
        List<TreeModel> treeModels = TreeModelUtil.encodeDecisionTreeEnsemble(model, model.treeWeights(), segmentSchema);
        Output output = GBTClassificationModelConverter.encodeOutput();
        MiningModel miningModel = new MiningModel(MiningFunction.REGRESSION, ModelUtil.createMiningSchema((Schema)segmentSchema)).setSegmentation(MiningModelUtil.createSegmentation((Segmentation.MultipleModelMethod)Segmentation.MultipleModelMethod.SUM, treeModels)).setOutput(output);
        return MiningModelUtil.createBinaryLogisticClassification((Schema)schema, (Model)miningModel, (double)1000.0, (boolean)false);
    }

    private static Output encodeOutput() {
        OutputField gbtValue = new OutputField(FieldName.create((String)"gbtValue"), DataType.DOUBLE).setOpType(OpType.CONTINUOUS).setResultFeature(ResultFeature.PREDICTED_VALUE).setFinalResult(Boolean.valueOf(false));
        OutputField binarizedGbtValue = new OutputField(FieldName.create((String)"binarizedGbtValue"), DataType.DOUBLE).setOpType(OpType.CONTINUOUS).setResultFeature(ResultFeature.TRANSFORMED_VALUE).setFinalResult(Boolean.valueOf(false)).setExpression((Expression)PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{PMMLUtil.createApply((String)"greaterThan", (Expression[])new Expression[]{new FieldRef(gbtValue.getName()), PMMLUtil.createConstant((Object)0.0)}), PMMLUtil.createConstant((Object)-1.0), PMMLUtil.createConstant((Object)1.0)}));
        Output output = new Output().addOutputFields(new OutputField[]{gbtValue, binarizedGbtValue});
        return output;
    }
}

