/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.ml.feature.IDFModel;
import org.apache.spark.ml.linalg.Vector;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.ProductFeature;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.SparkMLEncoder;
import org.jpmml.sparkml.TermFeature;
import org.jpmml.sparkml.WeightedTermFeature;

public class IDFModelConverter
extends FeatureConverter<IDFModel> {
    public IDFModelConverter(IDFModel transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        IDFModel transformer = (IDFModel)this.getTransformer();
        List<Feature> features = encoder.getFeatures(transformer.getInputCol());
        Vector idf = transformer.idf();
        if (idf.size() != features.size()) {
            throw new IllegalArgumentException();
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            Double weight = idf.apply(i);
            ProductFeature productFeature = new ProductFeature((PMMLEncoder)encoder, feature, weight){
                private WeightedTermFeature weightedTermFeature;
                {
                    this.weightedTermFeature = null;
                }

                public ContinuousFeature toContinuousFeature() {
                    if (this.weightedTermFeature == null) {
                        TermFeature termFeature = (TermFeature)this.getFeature();
                        Number factor = this.getFactor();
                        this.weightedTermFeature = termFeature.toWeightedTermFeature(factor);
                    }
                    return this.weightedTermFeature.toContinuousFeature();
                }
            };
            result.add((Feature)productFeature);
        }
        return result;
    }
}

