/*
 * Copyright (c) 2016 Villu Ruusmann
 *
 * This file is part of JPMML-SparkML
 *
 * JPMML-SparkML is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JPMML-SparkML is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with JPMML-SparkML.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.jpmml.sparkml;

import java.util.List;

import com.google.common.primitives.Doubles;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;

public class VectorUtil {

	private VectorUtil(){
	}

	static
	public void checkSize(int size, Vector... vectors){

		for(Vector vector : vectors){

			if(vector.size() != size){
				throw new IllegalArgumentException("Expected " + size + " element(s), got " + vector.size() + " element(s)");
			}
		}
	}

	static
	public List<Double> toList(Vector vector){
		DenseVector denseVector = vector.toDense();

		double[] values = denseVector.values();

		return Doubles.asList(values);
	}
}