/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.feature.Interaction;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.Feature;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.FeatureMapper;
import org.jpmml.sparkml.FeatureUtil;
import org.jpmml.sparkml.InteractionFeature;

public class InteractionConverter
extends FeatureConverter<Interaction> {
    public InteractionConverter(Interaction transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(FeatureMapper featureMapper) {
        Interaction transformer = (Interaction)this.getTransformer();
        String name = "";
        List<Feature> features = new ArrayList<Feature>();
        String[] inputCols = transformer.getInputCols();
        for (int i = 0; i < inputCols.length; ++i) {
            String inputCol = inputCols[i];
            List<Feature> inputFeatures = featureMapper.getFeatures(inputCol);
            if (i == 0) {
                name = inputCol;
                features = inputFeatures;
                continue;
            }
            name = name + ":" + inputCol;
            ArrayList<InteractionFeature> interactionFeatures = new ArrayList<InteractionFeature>();
            int index = 0;
            for (Feature feature : features) {
                for (Feature inputFeature : inputFeatures) {
                    Apply apply = new Apply("*").addExpressions(new Expression[]{FeatureUtil.toContinuousFeature(feature).ref(), FeatureUtil.toContinuousFeature(inputFeature).ref()});
                    DerivedField derivedField = featureMapper.createDerivedField(FieldName.create((String)(name + "[" + index + "]")), OpType.CONTINUOUS, DataType.DOUBLE, (Expression)apply);
                    InteractionFeature interactionFeature = new InteractionFeature((TypeDefinitionField)derivedField, Arrays.asList(feature, inputFeature));
                    interactionFeatures.add(interactionFeature);
                    ++index;
                }
            }
            features = interactionFeatures;
        }
        return features;
    }
}

