/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.ml.feature.OneHotEncoder;
import org.apache.spark.ml.param.Param;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.ListFeature;
import org.jpmml.sparkml.ConvertibleBinaryFeature;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.FeatureMapper;
import scala.Option;

public class OneHotEncoderConverter
extends FeatureConverter<OneHotEncoder> {
    public OneHotEncoderConverter(OneHotEncoder transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(final FeatureMapper featureMapper) {
        OneHotEncoder transformer = (OneHotEncoder)this.getTransformer();
        ListFeature inputFeature = (ListFeature)featureMapper.getOnlyFeature(transformer.getInputCol());
        List values = inputFeature.getValues();
        boolean dropLast = true;
        Option dropLastOption = transformer.get((Param)transformer.dropLast());
        if (dropLastOption.isDefined()) {
            dropLast = (Boolean)dropLastOption.get();
        }
        if (dropLast) {
            values = values.subList(0, values.size() - 1);
        }
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (String value : values) {
            ConvertibleBinaryFeature feature = new ConvertibleBinaryFeature(inputFeature.getName(), DataType.STRING, value){
                private ContinuousFeature continuousFeature;
                {
                    super(x0, x1, x2);
                    this.continuousFeature = null;
                }

                @Override
                public ContinuousFeature toContinuousFeature() {
                    if (this.continuousFeature == null) {
                        this.continuousFeature = this.createContinuousFeature();
                    }
                    return this.continuousFeature;
                }

                private ContinuousFeature createContinuousFeature() {
                    NormDiscrete normDiscrete = new NormDiscrete(this.getName(), this.getValue());
                    DerivedField derivedField = featureMapper.createDerivedField(FieldName.create((String)(this.getName().getValue() + "=" + this.getValue())), OpType.CONTINUOUS, DataType.DOUBLE, (Expression)normDiscrete);
                    ContinuousFeature feature = new ContinuousFeature((TypeDefinitionField)derivedField);
                    return feature;
                }
            };
            result.add((Feature)feature);
        }
        return result;
    }
}

