/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.spark.ml.linalg.Vector;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.regression.CategoricalPredictor;
import org.dmg.pmml.regression.NumericPredictor;
import org.dmg.pmml.regression.PredictorTerm;
import org.dmg.pmml.regression.RegressionTable;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.Schema;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sparkml.FeatureUtil;
import org.jpmml.sparkml.InteractionFeature;

public class RegressionModelUtil {
    private RegressionModelUtil() {
    }

    public static RegressionTable encodeRegressionTable(double intercept, Vector coefficients, Schema schema) {
        RegressionTable regressionTable = new RegressionTable(intercept);
        List features = schema.getFeatures();
        if (features.size() != coefficients.size()) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = (Feature)features.get(i);
            if (feature instanceof InteractionFeature) {
                InteractionFeature interactionFeature = (InteractionFeature)feature;
                PredictorTerm predictorTerm = new PredictorTerm().setCoefficient(coefficients.apply(i));
                List<FieldRef> fieldRefs = RegressionModelUtil.createFieldRefs(interactionFeature);
                predictorTerm.addFieldRefs(fieldRefs.toArray(new FieldRef[fieldRefs.size()]));
                regressionTable.addPredictorTerms(new PredictorTerm[]{predictorTerm});
                continue;
            }
            if (feature instanceof ContinuousFeature) {
                ContinuousFeature continuousFeature = (ContinuousFeature)feature;
                NumericPredictor numericPredictor = new NumericPredictor().setName(continuousFeature.getName()).setCoefficient(coefficients.apply(i));
                regressionTable.addNumericPredictors(new NumericPredictor[]{numericPredictor});
                continue;
            }
            if (feature instanceof BinaryFeature) {
                BinaryFeature binaryFeature = (BinaryFeature)feature;
                String value = ValueUtil.formatValue((Object)binaryFeature.getValue());
                CategoricalPredictor categoricalPredictor = new CategoricalPredictor().setName(binaryFeature.getName()).setCoefficient(coefficients.apply(i)).setValue(value);
                regressionTable.addCategoricalPredictors(new CategoricalPredictor[]{categoricalPredictor});
                continue;
            }
            throw new IllegalArgumentException();
        }
        return regressionTable;
    }

    private static List<FieldRef> createFieldRefs(InteractionFeature feature) {
        ArrayList<FieldRef> fieldRefs = new ArrayList<FieldRef>();
        List<Feature> inputFeatures = feature.getFeatures();
        for (Feature inputFeature : inputFeatures) {
            if (inputFeature instanceof InteractionFeature) {
                InteractionFeature interactionFeature = (InteractionFeature)inputFeature;
                fieldRefs.addAll(RegressionModelUtil.createFieldRefs(interactionFeature));
                continue;
            }
            inputFeature = FeatureUtil.toContinuousFeature(inputFeature);
            fieldRefs.add(inputFeature.ref());
        }
        return fieldRefs;
    }
}

