/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.sql.types.StructType;
import org.dmg.pmml.PMML;
import org.jpmml.model.MetroJAXBUtil;
import org.jpmml.model.SerializationUtil;
import org.jpmml.sparkml.ConverterUtil;

public class Main {
    @Parameter(names={"--help"}, description="Show the list of configuration options and exit", help=true)
    private boolean help = false;
    @Parameter(names={"--ser-schema-input"}, description="Schema SER input file", required=true)
    private File schemaInput = null;
    @Parameter(names={"--ser-pipeline-input"}, description="Pipeline SER input file", required=true)
    private File pipelineInput = null;
    @Parameter(names={"--pmml-output"}, description="PMML output file", required=true)
    private File output = null;

    public static void main(String ... args) throws Exception {
        Main main = new Main();
        JCommander commander = new JCommander((Object)main);
        commander.setProgramName(Main.class.getName());
        try {
            commander.parse(args);
        }
        catch (ParameterException pe) {
            StringBuilder sb = new StringBuilder();
            sb.append(pe.toString());
            sb.append("\n");
            commander.usage(sb);
            System.err.println(sb.toString());
            System.exit(-1);
        }
        if (main.help) {
            StringBuilder sb = new StringBuilder();
            commander.usage(sb);
            System.out.println(sb.toString());
            System.exit(0);
        }
        main.run();
    }

    private void run() throws Exception {
        StructType schema = (StructType)Main.deserialize(this.schemaInput);
        PipelineModel pipelineModel = (PipelineModel)Main.deserialize(this.pipelineInput);
        PMML pmml = ConverterUtil.toPMML(schema, pipelineModel);
        try (FileOutputStream os = new FileOutputStream(this.output);){
            MetroJAXBUtil.marshalPMML((PMML)pmml, (OutputStream)os);
        }
    }

    public File getSchemaInput() {
        return this.schemaInput;
    }

    public void setSchemaInput(File schemaInput) {
        this.schemaInput = schemaInput;
    }

    public File getPipelineInput() {
        return this.pipelineInput;
    }

    public void setPipelineInput(File pipelineInput) {
        this.pipelineInput = pipelineInput;
    }

    public File getOutput() {
        return this.output;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    private static Object deserialize(File file) throws ClassNotFoundException, IOException {
        try (FileInputStream is = new FileInputStream(file);){
            Object object = SerializationUtil.deserialize((InputStream)is);
            return object;
        }
    }
}

