/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.spark.ml.feature.Bucketizer;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.DiscretizeBin;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Interval;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.SparkMLEncoder;

public class BucketizerConverter
extends FeatureConverter<Bucketizer> {
    public BucketizerConverter(Bucketizer transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        Bucketizer transformer = (Bucketizer)this.getTransformer();
        ContinuousFeature feature = (ContinuousFeature)encoder.getOnlyFeature(transformer.getInputCol());
        Discretize discretize = new Discretize(feature.getName());
        ArrayList<String> categories = new ArrayList<String>();
        double[] splits = transformer.getSplits();
        for (int i = 0; i < splits.length - 1; ++i) {
            String category = String.valueOf(i);
            categories.add(category);
            Interval interval = new Interval(i < splits.length - 2 ? Interval.Closure.CLOSED_OPEN : Interval.Closure.CLOSED_CLOSED).setLeftMargin(BucketizerConverter.formatMargin(splits[i])).setRightMargin(BucketizerConverter.formatMargin(splits[i + 1]));
            DiscretizeBin discretizeBin = new DiscretizeBin(category, interval);
            discretize.addDiscretizeBins(new DiscretizeBin[]{discretizeBin});
        }
        DerivedField derivedField = encoder.createDerivedField(BucketizerConverter.formatName(transformer), OpType.CONTINUOUS, DataType.INTEGER, (Expression)discretize);
        return Collections.singletonList(new CategoricalFeature((PMMLEncoder)encoder, (TypeDefinitionField)derivedField, categories));
    }

    private static Double formatMargin(double value) {
        if (Double.isInfinite(value)) {
            return null;
        }
        return value;
    }
}

