/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.apache.spark.ml.feature.VectorIndexerModel;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Row;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.DOMUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.ValueUtil;
import org.jpmml.sparkml.FeatureConverter;
import org.jpmml.sparkml.SparkMLEncoder;

public class VectorIndexerModelConverter
extends FeatureConverter<VectorIndexerModel> {
    private static final Comparator<Map.Entry<Double, Integer>> COMPARATOR = new Comparator<Map.Entry<Double, Integer>>(){

        @Override
        public int compare(Map.Entry<Double, Integer> left, Map.Entry<Double, Integer> right) {
            return left.getValue().compareTo(right.getValue());
        }
    };

    public VectorIndexerModelConverter(VectorIndexerModel transformer) {
        super(transformer);
    }

    @Override
    public List<Feature> encodeFeatures(SparkMLEncoder encoder) {
        VectorIndexerModel transformer = (VectorIndexerModel)this.getTransformer();
        List<Feature> features = encoder.getFeatures(transformer.getInputCol());
        int numFeatures = transformer.numFeatures();
        if (numFeatures != features.size()) {
            throw new IllegalArgumentException();
        }
        Map categoryMaps = transformer.javaCategoryMaps();
        ArrayList<Feature> result = new ArrayList<Feature>();
        for (int i = 0; i < numFeatures; ++i) {
            Feature feature = features.get(i);
            Map categoryMap = (Map)categoryMaps.get(i);
            if (categoryMap != null) {
                ArrayList<String> categories = new ArrayList<String>();
                ArrayList<String> values = new ArrayList<String>();
                DocumentBuilder documentBuilder = DOMUtil.createDocumentBuilder();
                InlineTable inlineTable = new InlineTable();
                List<String> columns = Arrays.asList("input", "output");
                ArrayList entries = new ArrayList(categoryMap.entrySet());
                Collections.sort(entries, COMPARATOR);
                for (Map.Entry entry : entries) {
                    String category = ValueUtil.formatValue((Number)((Number)entry.getKey()));
                    categories.add(category);
                    String value = ValueUtil.formatValue((Number)((Number)entry.getValue()));
                    values.add(value);
                    Row row = DOMUtil.createRow((DocumentBuilder)documentBuilder, columns, Arrays.asList(category, value));
                    inlineTable.addRows(new Row[]{row});
                }
                encoder.toCategorical(feature.getName(), categories);
                MapValues mapValues = new MapValues().addFieldColumnPairs(new FieldColumnPair[]{new FieldColumnPair(feature.getName(), columns.get(0))}).setOutputColumn(columns.get(1)).setInlineTable(inlineTable);
                DerivedField derivedField = encoder.createDerivedField(VectorIndexerModelConverter.formatName(transformer, i), OpType.CATEGORICAL, DataType.INTEGER, (Expression)mapValues);
                result.add((Feature)new CategoricalFeature((PMMLEncoder)encoder, (TypeDefinitionField)derivedField, values));
                continue;
            }
            result.add((Feature)((ContinuousFeature)feature));
        }
        return result;
    }
}

