/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml.model;

import java.util.List;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.regression.RegressionTable;
import org.jpmml.converter.CategoricalLabel;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.Schema;
import org.jpmml.converter.regression.RegressionModelUtil;
import org.jpmml.sparkml.ClassificationModelConverter;
import org.jpmml.sparkml.VectorUtil;

public class LogisticRegressionModelConverter
extends ClassificationModelConverter<LogisticRegressionModel> {
    public LogisticRegressionModelConverter(LogisticRegressionModel model) {
        super(model);
    }

    public RegressionModel encodeModel(Schema schema) {
        LogisticRegressionModel model = (LogisticRegressionModel)this.getTransformer();
        CategoricalLabel categoricalLabel = (CategoricalLabel)schema.getLabel();
        if (categoricalLabel.size() != 2) {
            throw new IllegalArgumentException();
        }
        RegressionTable activeRegressionTable = RegressionModelUtil.createRegressionTable((List)schema.getFeatures(), (Double)model.intercept(), VectorUtil.toList(model.coefficients())).setTargetCategory(categoricalLabel.getValue(1));
        RegressionTable passiveRegressionTable = new RegressionTable(0.0).setTargetCategory(categoricalLabel.getValue(0));
        RegressionModel regressionModel = new RegressionModel(MiningFunction.CLASSIFICATION, ModelUtil.createMiningSchema((Schema)schema), null).setNormalizationMethod(RegressionModel.NormalizationMethod.SOFTMAX).addRegressionTables(new RegressionTable[]{activeRegressionTable, passiveRegressionTable}).setOutput(ModelUtil.createProbabilityOutput((Schema)schema));
        return regressionModel;
    }
}

