/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.sparkml;

import java.util.Collections;
import org.apache.spark.ml.PredictionModel;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Label;
import org.jpmml.converter.ModelUtil;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.sparkml.ModelConverter;
import org.jpmml.sparkml.SparkMLEncoder;

public abstract class RegressionModelConverter<T extends PredictionModel<Vector, T> & HasFeaturesCol>
extends ModelConverter<T> {
    public RegressionModelConverter(T model) {
        super(model);
    }

    @Override
    public MiningFunction getMiningFunction() {
        return MiningFunction.REGRESSION;
    }

    @Override
    public Output encodeOutput(Label label, SparkMLEncoder encoder) {
        PredictionModel model;
        PredictionModel hasPredictionCol = model = (PredictionModel)this.getTransformer();
        String predictionCol = hasPredictionCol.getPredictionCol();
        OutputField predictedField = ModelUtil.createPredictedField((FieldName)FieldName.create((String)predictionCol), (DataType)label.getDataType(), (OpType)OpType.CONTINUOUS);
        Output output = new Output().addOutputFields(new OutputField[]{predictedField});
        encoder.putFeatures(predictionCol, Collections.singletonList(new ContinuousFeature((PMMLEncoder)encoder, predictedField.getName(), predictedField.getDataType())));
        return output;
    }
}

